package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 墨迹操作系统
 *
 * @author hillchen
 * @create 2019/3/28 12:03
 */
public enum MojiOS {
    ANDROID(0,"android"),
    IOS(1,"ios"),
    WINPHONE(2,"winPhone"),
    OTHER(3,"others")
    ;
    private Integer osType;
    private String osName;

    MojiOS(Integer osType, String osName) {
        this.osType = osType;
        this.osName = osName;
    }

    public Integer getOsType() {
        return osType;
    }

    public String getOsName() {
        return osName;
    }

    public static MojiOS getMojiOS(Integer osType){
        for(MojiOS mojiOS : MojiOS.values()){
            if(Objects.equals(osType,mojiOS.osType)){
                return mojiOS;
            }
        }
        return OTHER;
    }
}
