package cn.com.duiba.tuia.activity.center.api.dto.subtitle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author: xuesong
 * @Date: 2020-06-30 15:58
 * @Description: 组件化
 */
@Data
public class SubDTO implements Serializable {

    public static String ALGO_MD5_SIGN = "algoMd5Sign";

    public static String SALT_MD5 = "组件化盐值，猜不到";

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 【奖品】一个奖品组合，包含多个个奖品（槽位）
     */
    private List<Long> prizeIds;

    /**
     * 【广告】广告图片列表
     * &advertIdMap=Encode之后的JSON
     */
    private Map<Long, String> advertIdMap;

    /**
     * 主标题id
     */
    private Long mainTitleId;
    /**
     * 副标题id
     */
    private Long subTitleId;

    /**
     * 盐值Md5处理
     *
     * @return
     */
    public static String getAlgoMd5Sign(SubDTO dto) {
        if (null == dto) {
            return "";
        }
        String s = JSON.toJSONString(dto);
        return DigestUtils.md5Hex(s + SALT_MD5);
    }

    /**
     * 转成链接，从站外到站内
     * 注意没有【&】
     *
     * @param subDTO
     * @return
     */
    public static String getUrlParam(SubDTO subDTO) throws UnsupportedEncodingException {
        if (null == subDTO) {
            return "";
        }
        Map<Long, String> advertIdMap = subDTO.getAdvertIdMap();
        String advertIdStr = JSON.toJSONString(advertIdMap);
        StringBuilder sb = new StringBuilder();
        sb.append("mainTitleId=").append(subDTO.getMainTitleId());
        sb.append("&subTitleId=").append(subDTO.getSubTitleId());
        sb.append("&prizeIds=").append(getStringFromList(subDTO.getPrizeIds()));
        sb.append("&advertIdMap=").append(URLEncoder.encode(advertIdStr, "UTF-8"));
        // MD5盐值
        String algoMd5Sign = getAlgoMd5Sign(subDTO);
        sb.append("&algoMd5Sign=").append(algoMd5Sign);
        return sb.toString();
    }


    /**
     * 广告对象获取
     * @return
     */
    public static Map<Long, String> getAdvertIdMapFromStr(String advertIdStr) throws Exception {
        Map<Long, String> mapRes = new HashMap<>();
        if (StringUtils.isEmpty(advertIdStr)) {
            return mapRes;
        }
        String decode = URLDecoder.decode(advertIdStr, "UTF-8");
        JSONObject parseObj = (JSONObject) JSON.parse(decode);
        for (String str : parseObj.keySet()) {
            mapRes.put(Long.valueOf(str), Optional.ofNullable(parseObj.get(str)).orElse("") + "");
        }
        return mapRes;
    }

    /**
     * List<Long>===>转成逗号拼接的字符串
     *
     * @param ids
     * @return
     */
    public static String getStringFromList(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return "";
        }
        return StringUtils.join(ids, ",");
    }

    public static List<Long> getListFromString(String idStr) {
        if (StringUtils.isEmpty(idStr)) {
            return new ArrayList<>();
        }
        String[] split = idStr.split(",");
        return Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
    }

}
