/**
 * 
 */
package cn.com.duiba.tuia.activity.center.api.dto.req;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 此类描述的是： 分页查询条件.
 *
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
public class ReqPageQuery extends BaseDto{


    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    private static final long serialVersionUID = -9052866712359237685L;


    /** 起始记录数. */
    protected Integer         rowStart        = 0;

    /** 当前页. */
    protected Integer         currentPage     = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    protected Integer         pageSize;

    protected Date start;

    protected Date end;

    /** 排序字段(默认排序字段为：gmt_modified). */
    private String          sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String          order           = "desc";

    /** 拼接字段查询使用*/
    @ApiModelProperty(value = "拼接字段", required = false)
    private String          conditionStr;

    public ReqPageQuery() {
        super();
    }

    public Date getStart() {
        return start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getConditionStr() {
        return conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }
}
