package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.ActivityOptionType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityTypeNum;
import cn.com.duiba.tuia.activity.center.api.dto.RspOrder;
import cn.com.duiba.tuia.activity.center.api.dto.req.ActivityOrderReq;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName: RemoteActivityOrderService <br/>
 * Function: 活动订单相关服务. <br/>
 * date: 2017年2月24日 下午3:02:09 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteActivityOrderService {

    /**
     * insert:(添加活动订单). <br/>
     *
     * @author wubo
     * @param dto
     * @return orderId
     * @since JDK 1.7
     */
    DubboResult<RspOrder> insert(ActivityOrderDto dto);

    /**
     * update:(更新). <br/>
     * orderId必填 其他字段只更新填写的字段
     * 
     * @author wubo
     * @param dto
     * @return
     * @since JDK 1.7
     */
    DubboResult<Long> updateByOrderId(ActivityOrderDto dto);

    /**
     * selectByConsumerId:(根据用户id查询). <br/>
     *
     * @author wubo
     * @param consumerId 用户id
     * @param offset
     * @param max
     * @return PageDto<ActivityOrderDto>
     * @since JDK 1.7
     */
    DubboResult<PageDto<ActivityOrderDto>> selectByConsumerId(Long consumerId, Integer offset, Integer max);

    /**
     * 根据用户和活动得到订单列表
     *
     * @param req
     * @return
     */
    PageDto<ActivityOrderDto> selectByFilter(ActivityOrderReq req);

    /**
     * selectByIdAndConsumerId:(根据订单id和用户id查询). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param orderId
     * @return
     * @since JDK 1.7
     */
    DubboResult<ActivityOrderDto> selectByOrderIdAndConsumerId(String orderId, Long consumerId);

    /**
     * selectConsumerJoinNumToday:(查询用户今天活动参数次数). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param activityId
     * @return
     * @since JDK 1.7
     */
    DubboResult<Integer> selectConsumerJoinNumToday(Long consumerId, Long activityId);

    /**
     * incrConsumerJoinNumToday:(用户今天参与活动次数+1). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param activityId
     * @return
     * @since JDK 1.7
     */
    DubboResult<Boolean> incrConsumerJoinNumToday(Long consumerId, Long activityId);

    /**
     * decrConsumerJoinNumToday:(用户今天参与活动次数-1). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param activityId
     * @return
     * @since JDK 1.7
     */
    DubboResult<Boolean> decrConsumerJoinNumToday(Long consumerId, Long activityId);

    /**
     * selectConsumerIdByOrderId:(根据订单id查用户id查询). <br/>
     *
     * @author xuefeng
     * @param orderId
     * @return
     * @since JDK 1.8
     */
    Long selectConsumerIdByOrderId(String orderId);



    /**
     * 查询用户下的某个类型的所有的订单信息
     *
     * @param activityTypeNum 活动的activity_type 类型,属于哪个业务系统
     * @param activityOptionType 奖品的类型
     * @param consumerId     用户
     * @return 查询到的所有订单
     */
    List<ActivityOrderDto> selectByPrizeTypeAndCid(ActivityTypeNum activityTypeNum, ActivityOptionType activityOptionType, Long consumerId);

    /**
     * 得到一个订单ID
     *
     * @param consumerId
     * @return
     */
    String createOrderId(Long consumerId);

    /**
     * 批量创建订单号
     *
     * @param consumerId
     * @param batchSize 批次的最大个数 ( 10 )
     * @return
     */
    List<String> batchCreateOrderId(Long consumerId, int batchSize);

}
