package cn.com.duiba.tuia.activity.center.api.remoteservice.commodity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.commodity.ActivityCommerceDto;

import java.util.List;

/**
 * 活动[二类电商]
 * Created by xuefeng on 2020/7/13.
 */
@AdvancedFeignClient
public interface RemoteActivityCommerceService {

    /**
     * 获取活动对应商品列表
     * @param activityId 活动id
     * @return
     */
    List<ActivityCommerceDto> getActivityCommercesGoods(Long activityId);

    /**
     * 保存活动商品关联信息
     * @param activityCommerceDtos 活动关联商品信息
     * @return
     */
    Boolean saveActivityCommerce(List<ActivityCommerceDto> activityCommerceDtos);

    /**
     * 根据活动商品关联ids删除
     * @param ids 关联ids
     * @return
     */
    Boolean deleteActivityCommerces(List<Long> ids);
}
