package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.*;
import cn.com.duiba.tuia.activity.center.api.dto.req.RechargeReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqAliOrderQuery;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by wubo on 2017/7/10.
 */
@AdvancedFeignClient
public interface RemoteAlipayService {

    DubboResult<Integer> insertAlipayOrder(AlipayOrderDto dto);

    DubboResult<Integer> updateAlipayOrderByOrderId(AlipayOrderDto dto);

    DubboResult<AlipayOrderDto> selectAlipayOrderByOrderId(String orderId);

    @RequestMapping("selectAlipayOrderPageMulti")
    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="30000")
    DubboResult<PageDto<AlipayOrderDto>> selectAlipayOrderPage(Integer offset, Integer max, List<Integer> status,
                                                               List<Long> activityIds, List<Long> appIds);

    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="30000")
    DubboResult<PageDto<AlipayOrderDto>> selectAlipayOrderPage(ReqAliOrderQuery req);

    /**
     * 从es查询订单列表
     *
     * @param req
     * @return
     */
    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="30000")
    DubboResult<PageDto<AlipayOrderDto>> selectAlipayOrderPageFromES(ReqAliOrderQuery req);

    /**
     * @Description: selectAlipayOrderByDeviceId 根据设备id查询用户某段时间区间内所有转账记录
     *
     * @Param: [deviceId, start, end]
     * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto>>
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/12
     */
    DubboResult<List<AlipayOrderDto>> selectAlipayOrderByDeviceId(Long optionId, String deviceId, Date start, Date end);


    /**
     * @Description: toAccountTransfer 转账接口
     * @Param: [params]
     * @Return: cn.com.duiba.tuia.activity.center.api.dto.AlipayRsp
     * @throws:
     * @author: youhaijun
     * @Date: 2017/7/14
     */
    DubboResult<AlipayRsp> toAccountTransfer(AlipayParam params);

    /**
     * 活动Id、时间段查询支付宝直充奖项订单数据统一接口
     * @param activityIds
     * @param startDate  与endDate 同时为null时，直接根据活动id查询
     * @param endDate   与startDate 同时为null时，直接根据活动id查询  只存在同时为空 同时补位空的情况
     * @return
     */
    DubboResult<List<AlipayPrizeDataDto>> selectActivityAlipayData(List<Long> activityIds, String startDate, String endDate);

    /**
     * 活动Id、时间段查询支付宝直充奖项订单数据统一接口
     * @param activityIds
     * @param startDate  与endDate 同时为null时，直接根据活动id查询
     * @param endDate   与startDate 同时为null时，直接根据活动id查询  只存在同时为空 同时补位空的情况
     * @Param type 1:活动类型，2：插件活动类型
     * @return
     */
    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="30000")
    DubboResult<List<AlipayPrizeDataDto>> selectActivityAwardData(List<Long> activityIds, String startDate, String endDate,Integer type);

    /**
     * 查询活动中奖数据
     * @param activityIds
     * @param type
     * @return
     */
    List<AlipayPrizeDataDto> getActivityAwardData(List<Long> activityIds,Integer type);
    /**
     * 查询活动每日数据
     * 返回数据维度奖项id+时间（天）
     * 客户端计算每天的数据总计
     * web展示格式
     *  day1
     *    奖项1
     *    奖项2
     *  day2
     *    奖项1
     *    奖项2
     * @param activityId 活动id
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     */
    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="30000")
    DubboResult<List<AlipayPrizeDataDto>> selectActivityDailyAlipayData(Long activityId, Date startDate,Date endDate);

    /**
     * 获取活动每日中奖数据（数据源HBASE）
     * @param activityId
     * @param start
     * @param end
     * @param type
     * @return
     */
    List<AlipayPrizeDataDto> getAwardDailyData(Long activityId,String start, String end, Integer type);
    
    /**
     * 获取时间段消耗
     * @param start
     * @param end
     * @return
     */
    Long getConsumeByDays(String start, String end);
    /**
     * 查询活动每日数据
     * 返回数据维度奖项id+时间（天）
     * 客户端计算每天的数据总计
     * web展示格式
     *  day1
     *    奖项1
     *    奖项2
     *  day2
     *    奖项1
     *    奖项2
     * @param activityId 活动id
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @param type 1:活动类型，2：插件工具类型
     * @return
     */
    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="30000")
    DubboResult<List<AlipayPrizeDataDto>> selectActivityDailyAwardData(Long activityId, Date startDate,Date endDate,Integer type);


    /***
         * @Description: selectOrderCount 查询分页总数
         *
         * @Param: [req]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Integer>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/8/8
         */
    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="30000")
    DubboResult<Integer> selectOrderCount(ReqAliOrderQuery req);

    /**
     *
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return          这段时间的奖品的总消耗
     */
    DubboResult<Long> selectTotalAward(Date startDate, Date endDate);

    /**
     *
     * @param optionId 奖项ID
     * @return
     */
    DubboResult<List<VirtualAwardAccountDto>> selectAwardAccountInfo(Long optionId);

    /**
     * 批量成功账号收集订单
     * @param orderIds
     * @return
     */
    DubboResult<Integer> updateAwardAccountStatus(List<Long> orderIds);

    RechargeQBRsp rechargeQB(String orderId, String qqNumber, String amount);
    RechargeQBRsp rechargeQBAgain(String orderId,String qqNumber);
    Boolean updateQBOrderSuccess(String orderId);
    Boolean updateQBOrderFailed(String orderId);

    /**
     * 领奖
     * 涉及第三方接口的领奖
     * 话费
     * @param rechargeReq
     * @return
     */
    Boolean recharge(RechargeReq rechargeReq);

    /**
     * 插入重复领取告警订单
     * @param orderId    订单id
     * @param accountId  账号Id
     * @param adId       广告位id
     * @param activityId 活动Id
     * @param prizeId    奖项Id
     * @param prizeName  奖项名
     * @param time       重复时间点
     * @return
     */
    Boolean addWarnOrder(String orderId, String accountId, String adId, String activityId, String prizeId, String prizeName, Date time);

    /**
     * 更新订单，标记为重复订单
     * @param orderIds
     * @return
     */
    Integer updateOrderRepeat(List<String> orderIds);

    /**
     *
     * 查询重复领取实物奖品订单
     * @param orderId 订单号
     * @return 重复订单列表
     */
    @FeignHystrixProperty(name=HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS ,value="15000")
    PageDto<AlipayOrderDto> selectDupOrdersByOrderId(String orderId, Integer offset, Integer max);

    /**
     * 获取订单列表
     * @param orderIdList 推啊订单列表
     * @return 订单列表
     */
    List<AlipayOrderDto> selectByTwaOrderIdList(List<String> orderIdList) throws BizException;



    DubboResult<Map<String,Long>> selectIdByParam(ReqAliOrderQuery req);


    DubboResult<List<AlipayOrderDto>> selectAlipayOrderPageById(ReqAliOrderQuery req);

    /**
     * 列出联通用户近30天的话费充值订单
     * @param deviceId
     * @param appId
     * @return
     */
    List<AlipayOrderDto> listUnicomBillOrders(String deviceId, Long appId);

    /**
     * 联通话费充值接口
     * @param rechargeReq
     * @return
     */
    Boolean rechargeForUnicom(RechargeReq rechargeReq);
}
