/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.story.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;

public enum TreeType {
    NORMAL(1, "\u666e\u901a", 1),
    COCONUT(2, "\u6930\u5b50\u7ea2\u5305\u6811", 2),
    LOTUS(3, "\u84ec\u84ec\u7ea2\u5305\u6811", 3),
    MUSHROOM(4, "\u8611\u83c7\u7ea2\u5305\u6811", 4);

    private Integer type;
    private String desc;
    private Integer sort;

    private TreeType(Integer type, String desc, Integer sort) {
        this.type = type;
        this.desc = desc;
        this.sort = sort;
    }

    public static TreeType valueOf(Integer type) {
        for (TreeType typeEnum : TreeType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum;
        }
        return null;
    }

    public static TreeType getNextTree(Integer type) {
        if (type == null) {
            return NORMAL;
        }
        ArrayList treeTypeList = Lists.newArrayList((Object[])TreeType.values());
        treeTypeList.sort(Comparator.comparingInt(TreeType::getSort));
        int index = -1;
        for (TreeType tree : treeTypeList) {
            ++index;
            if (!type.equals(tree.getType())) continue;
            break;
        }
        if (index >= treeTypeList.size() - 1) {
            return null;
        }
        return (TreeType)((Object)treeTypeList.get(index + 1));
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }
}

