package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.bean.response.DeliveryGroupDTO;
import cn.com.duiba.tuia.activity.center.api.bean.response.DeliveryGroupRes;
import cn.com.duiba.tuia.activity.center.api.bean.response.DeliveryGroupWithIdea;
import cn.com.duiba.tuia.activity.center.api.dto.req.DeliveryGroupQueryReq;

import java.util.List;

/**
 * 〈一句话功能简述〉<br
 * Description: 投放组功能开发
 *
 * @author xierongli
 * @create 2019/08/28 16:08
 */
@AdvancedFeignClient
public interface RemoteDeliveryGroupService {

    /**
     * 新建投放组
     * @param resourceLocationId 资源位Id
     * @param putRatio 投放比例
     * @param putType 投放方式
     * @return 主键
     */
    Long addDeliveryGroup(Long resourceLocationId, Integer putType, Integer putRatio) throws BizException;
    /**
     * 初始化资源位的投放组
     */
    void initResourceLocationDeliveryGroup();
    /**
     *
     * 根据资源位ID生成投放组初始数据
     * @param resourceLocationId 资源位Id
     * @return 生成数量
     */
    Integer generateDeliveryGroup(Long resourceLocationId);

    /**
     * 按照日期与投放方式查询统计数据
     *
     * @param resourceLocationId 资源位Id
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @param putType 投放方式 1依次 2按比例 3按算法
     * @return 统计信息（成本，收入， 点击率， ROI）
     */
    DeliveryGroupRes queryReportData(DeliveryGroupQueryReq req);

    /**
     * 更新投放组状态和占比
     *
     * @param deliveryGroupId 投放组Id
     * @param status 状态值
     * @return true :成功 flase : 失败
     */
    Integer updateDeliveryGroupStatus(Long deliveryGroupId, Integer status) throws  BizException;


    /**
     * 更新投放组状态和占比
     *
     * @param deliveryGroupId 投放组Id
     * @param putRatio 状态值
     * @return true :成功 flase : 失败
     */
    Integer updateDeliveryGroupPutRatio(Long deliveryGroupId, Integer putRatio) throws BizException;


    /**
     * 查询资源位下投放组列表
     *
     * @param resourceLocationId 资源位Id
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @return 投放组关联创意集合
     */
    List<DeliveryGroupWithIdea> queryForListWithIdeas(Long resourceLocationId, String startDate, String endDate);

    /**
     * 根据资源位查询投放组集合集
     * @param resourceLocationId 资源位ID
     * @return 集合
     */
    List<DeliveryGroupDTO> queryForList(Long resourceLocationId);

    /**
     * 查询有效的资源位投放组
     *
     * @param resourceId
     * @return
     */
    List<DeliveryGroupDTO> queryValidListByResourceId(Long resourceId);

    /**
     * 根据投放组ID查询投放组对象
     *
     * @param delGroupId
     * @return
     */
    DeliveryGroupDTO queryDeliveryGroupById(Long delGroupId);

    /**
     * 根据资源位Id查询总的占比
     * @param resourceLocationId 资源位Id
     * @return 占比总值
     */
    Integer getPutRatioByResourceId(Long resourceLocationId);

    /**
     * 判断投放方式是否创建
     * @param resourceLocationId 资源位
     * @param putType 投放方式
     * @return
     */
    Integer judgePutTypeExist(Long resourceLocationId, Integer putType);




}
