package cn.com.duiba.tuia.activity.center.api.dto.adx.audit;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class AdvertiserAuditStatusDto implements Serializable {

    private static final long serialVersionUID = 661661104405556373L;

    /**
     * 广告主id
     */
    private Long advertiserId;

    /**
     * 广告主名
     */
    private String advertiserName;

    /**
     * adx类型
     */
    private Integer adxType;

    /**
     * 企业/个体营业执照
     */
    private String businessLicense;

    /**
     * 计算机软件著作权登记证书
     */
    private List<AdvertiserAuditFileDto> files;

    /**
     * 送审原因(0-落地页变更,1-素材内部审核通过,2-广告主资质变更)
     */
    private Integer auditReason;

    /**
     * 公司地址
     */
    private String address;

    /**
     * 营业执照注册号
     */
    private String businessLicenseRegistrationNumber;

    /**
     * 0.首次送审 1.非首次送审
     */
    private Integer isFirst;


}
