package cn.com.duiba.tuia.activity.center.api.dto.story.plant;

import cn.com.duiba.tuia.activity.center.api.dto.commercial.common.MissionDto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * [商业化活动]种红包主Dto
 *
 * @author zhangbaiqiang
 * @date 2018/03/08
 */
public class PlantDto implements Serializable {
    private static final long serialVersionUID = 8458496109720427879L;

    /**
     * 用户信息
     */
    private PlantUserDto user;

    /**
     * 土地信息
     */
    private List<PlantLandDto> land;

    /**
     * 种子仓库
     */
    private List<PlantSeedDto> seed;

    /**
     * 任务
     */
    private List<MissionDto> mission;

    /**
     * 闯关任务
     */
    private List<MissionDto> sceneMission;

    /**
     * 签到信息
     */
    private PlantSignDto sign;

    /**
     * 奖励信息
     */
    private PlantPrizeDto prize;

    /*
     * 道具信息
     * {"1":2}
     * */
    private Map<Integer, Integer> prop;

    /*
     * 土地状态，数组下标即为土地ID
     * */
    private List<Integer> landStatus;

    /*
     * 灾害传染地
     * */
    private Integer diseaseFromLandId;

    /*
     * 灾害被感染地
     * */
    private Integer diseaseToLandId;


    public PlantUserDto getUser() {
        return user;
    }

    public PlantDto setUser(PlantUserDto user) {
        this.user = user;
        return this;
    }

    public List<PlantLandDto> getLand() {
        return land;
    }

    public PlantDto setLand(List<PlantLandDto> land) {
        this.land = land;
        return this;
    }

    public PlantSignDto getSign() {
        return sign;
    }

    public PlantDto setSign(PlantSignDto sign) {
        this.sign = sign;
        return this;
    }

    public PlantPrizeDto getPrize() {
        return prize;
    }

    public PlantDto setPrize(PlantPrizeDto prize) {
        this.prize = prize;
        return this;
    }

    public List<PlantSeedDto> getSeed() {
        return seed;
    }

    public PlantDto setSeed(List<PlantSeedDto> seed) {
        this.seed = seed;
        return this;
    }

    public List<MissionDto> getMission() {
        return mission;
    }

    public void setMission(List<MissionDto> mission) {
        this.mission = mission;
    }

    public Map<Integer, Integer> getProp() {
        return prop;
    }

    public void setProp(Map<Integer, Integer> prop) {
        this.prop = prop;
    }

    public List<Integer> getLandStatus() {
        return landStatus;
    }

    public void setLandStatus(List<Integer> landStatus) {
        this.landStatus = landStatus;
    }

    public Integer getDiseaseFromLandId() {
        return diseaseFromLandId;
    }

    public void setDiseaseFromLandId(Integer diseaseFromLandId) {
        this.diseaseFromLandId = diseaseFromLandId;
    }

    public Integer getDiseaseToLandId() {
        return diseaseToLandId;
    }

    public void setDiseaseToLandId(Integer diseaseToLandId) {
        this.diseaseToLandId = diseaseToLandId;
    }

    public List<MissionDto> getSceneMission() {
        return sceneMission;
    }

    public void setSceneMission(List<MissionDto> sceneMission) {
        this.sceneMission = sceneMission;
    }
}
