package cn.com.duiba.tuia.activity.center.api.req.adx;

import cn.com.duiba.tuia.activity.center.api.annotation.AdxBidFullLink;
import lombok.Data;

import java.io.Serializable;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx曝光成功记录信息
 *
 * @author hillchen
 * @create 2019/2/27 00:48
 */
@Data
public class AdxSuccBidInfo implements Serializable {

    private static final long serialVersionUID = 6996300130162900166L;

    /**
     * adx全链路请求标示
     */
    private String adxRid;

    /**
     * adx平台广告位id
     */
    private String tagId;
    /**
     * 广告位索引
     */
    private String tagIndex;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 创意id
     */
    private Long ideaId;


    /**
     * 对应tuia的广告位id
     */
    private Long slotId;

    /**
     * 对应tuia的应用id
     */
    private Long addId;

    /**
     * 标准出价:分/1000次
     */
    private Long bidPrice;

    /**
     * 标准扣费:分/1000次
     */
    private Long feePrice;

    /**
     * 创意投放方式：0:依次投放,1:按比例投放
     */
    private Integer putType;

    /**
     * 出价类型0:人工出价,1:算法出价
     */
    private Integer priceType;

    /**
     * 计费方式：0:cpc，1:cpm（现有的adx都是cpm计费方式）
     */
    private Integer billType;

    /**
     * 扣费方式：1:一价扣费，2:二价扣费
     */
    private Integer feeType;

    /**
     * 记录状态：0:竞价返回，1:竞价成功，2:创意曝光，3:创意点击
     */
    private Integer recodeStatus;

    /** adxPriceLevel */
    private Integer adxPriceLevel;

    /** isCompareGroup */
    private String isCompareGroup;

    /** 策略类型 */
    private String strategy;

    /** 试探level */
    private String level;

    /** 拓展字段（map转string存入，防止反序列化时出现异常） */
    private String extMap;

    /** 策略类型 每个数字代表一个算法模型 示例 1 */
    private String algType;

    /** 推广组ID */
    private String adxGroupId;

    /**
     * 经纬度
     */
    private Double longitude;

    /**
     * 经纬度
     */
    private Double latitude;

    /**
     * 经纬度hash
     */
    private String geohash;

    /** 推广组ID */
    private String groupId;

    /** 1:预发券 2:非预发券 **/
    private Integer preLaunch;

    /** 0-免费 1-付费 **/
    private Integer appPaid;

    /** 0.测试组 1.对照组 **/
    private Integer isTestGroup;

    /**
     * ctr预估区间
     */
    @AdxBidFullLink
    private Integer preInterval;

    /**
     * abtest分流标记（1：对比组；2：测试组）
     */
    @AdxBidFullLink
    private Integer filterIndex;

    /**
     * pmp类型 0-RTB 1-PD 2-PDB
     */
    @AdxBidFullLink
    private Integer pmpType;

    /**
     * 推啊排期单ID
     */
    @AdxBidFullLink
    private Long tuiaDealId;

    /**
     * 点击价值分层
     */
    @AdxBidFullLink
    private Integer clickValueLevel;

    /**
     * 点击价值纠偏因子
     */
    @AdxBidFullLink
    private Double clickValueRectifyFactor;

    /**
     * 预估点击价值(TFModel)
     */
    @AdxBidFullLink
    private Double preClickValue;

    /**
     * 统计点击价值
     */
    @AdxBidFullLink
    private Double statClickValue;

    /**
     * 百度联盟appId标识符
     */
    @AdxBidFullLink
    private String baiduAppId;

    /**
     * pc端用户id(目前给百度联盟用的)
     */
    @AdxBidFullLink
    private String thirdUserId;

    /**
     * 广告计划Id
     */
    @AdxBidFullLink
    private Long advertId;

    /**
     * 定向配置包 Id
     */
    @AdxBidFullLink
    private Long orientationId;

    /**
     * 素材 Id
     */
    @AdxBidFullLink
    private Long materialId;

    /* 算法出价模式 */
    @AdxBidFullLink
    private Integer algoBidMode;

    /* 算法过滤原因 */
    @AdxBidFullLink
    private Integer filterType;

    /* 每PV发券预估值 */
    @AdxBidFullLink
    private Double preLaunchPv;

    /**
     * 频次等级：1.强 2.中 3.弱
     */
    @AdxBidFullLink
    private Integer frequencyLevel;

    /** 流量abtest组别  1=adx非测试流量，2=无，3=每pv发券，4=每pv点券 **/
    @AdxBidFullLink
    private Integer flowGroup;

    /** 每PV点券预估值 **/
    @AdxBidFullLink
    private Double preChargePv;

    /** 互动创意类型 （0-普通-静态，1-动态-dpa） **/
    @AdxBidFullLink
    private Integer idea_type;

    /** adx入口素材id **/
    @AdxBidFullLink
    private Long sckId;

    /**
     * 扩展map的key
     */
    public static class ExtMapKey {

        /** 预发券入参的key */
        public static String PRE_LOAD_ADVERT_PARAMS = "preLoadAdvertParams";
    }
}