package cn.com.duiba.tuia.activity.center.api.bean.enums;

import java.util.Objects;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2020/7/24
 * @description:
 **/
public enum TagRelationTypeEnum {

    TITLE(1,"标题"),
    PRIZE(2,"奖品"),
    ACTIVITY(3,"活动"),
    SCK(4,"素材"),
    KEY_WORD(6,"关键词"),
    INDUSTRY(7,"行业"),
    RISK(11,"风险"),
    FLOW(12,"流量"),
    FLOW_LEVEL(13,"流量分级"),
    DOMAIN_FLOW_LEVEL(14,"域名流量分级标签"),
    ;

    private Integer subType;

    private String desc;

    TagRelationTypeEnum(Integer subType, String desc) {
        this.subType = subType;
        this.desc = desc;
    }

    public static TagRelationTypeEnum getEnum(Integer type){
        for (TagRelationTypeEnum entry : TagRelationTypeEnum.values()) {
            if(Objects.equals(entry.getSubType(), type)) {
                return entry;
            }
        }
        return null;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
