package cn.com.duiba.tuia.activity.center.api.constant;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * ClassName: ActivityOptionType <br/>
 * Function: 奖项类型枚举. <br/>
 * date: 2017年1月13日 下午2:53:09 <br/>
 *
 * @author wubo
 * @version 1.0
 * @since JDK 1.7
 */
public enum ActivityOptionType {

    TYPE_COUPON("coupon", "优惠券"), TYPE_LUCKY("lucky", "福袋"), TYPE_NOTHING("nothing", "不关联奖品"),
    TYPE_THANKS("thanks", "谢谢参与"), TYPE_AGAIN("again", "再来一次") ,TYPE_PHYSICAL("physical","实物"),
    TYPE_ALIPAY("alipay", "支付宝直充"),TYPE_VIRTUAL("virtual","虚拟奖品"),TYPE_QB("qb","Q币"),TYPE_BILL("bill","话费"),
    TYPE_RANDOM_COIN("randomCoin","随机金币"),//友推使用
    TYPE_LARGE_COUPON("large_coupon","大额券")
    ;
         
    
    /** code:奖项类型. */
    private String code;

    /** desc:奖项类型描述. */
    private String desc;

    ActivityOptionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getCode:(奖项type). <br/>
     * 
     * @return String
     */
    public String getCode() {
        return code;
    }

    /**
     * getDesc:(奖项type描述). <br/>
     * 
     * @return String
     */
    public String getDesc() {
        return desc;
    }

    public boolean equalsCode(String type) {
        return code.equals(type);
    }

    /**
     * getDescByCode:(根据code获取描述). <br/>
     * 
     * @param code
     * @return
     */
    public static String getDescByCode(String code) {
        String desc = "";
        for (ActivityOptionType temp : ActivityOptionType.values()) {
            if (temp.getCode().equals(code)) {
                desc = temp.getDesc();
            }
        }
        return desc;
    }

    public static ActivityOptionType getByCode(String code){
        for (ActivityOptionType temp : ActivityOptionType.values()) {
            if (temp.getCode().equals(code)) {
                return temp;
            }
        }
        return null;
    }

    private static Set<String> stockType = new HashSet<>();
    static{
        stockType.add(TYPE_COUPON.code);
        stockType.add(TYPE_ALIPAY.code);
        stockType.add(TYPE_PHYSICAL.code);
        stockType.add(TYPE_VIRTUAL.code);
        stockType.add(TYPE_QB.code);
        stockType.add(TYPE_BILL.code);
    }

    /**
     * 是否是 有库存的奖项类型
     * @param type
     * @return
     */
    public static boolean isStockType(String type) {
        return stockType.contains(type);
    }

    //奖品类型：虚拟奖品，实物奖品，优惠券，支付宝，Q币，话费
    public static String getStockMsg(String type){
        if(StringUtils.isNotBlank(type)){
            if("virtual".equals(type) || "physical".equals(type) || "coupon".equals(type) || "alipay".equals(type) || "qb".equals(type) || "bill".equals(type)){
                String msg = "奖品类型：" + getByCode(type) + "库存不足，请尽快填充库存；今日不再报警按钮";
                return msg;
            }
        }
        return "";
    }

}
