package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityCustomConfigDto;

/**
 * @ClassName RemoteActivityCustomConfigService
 * @Description 活动定制配置
 * @Author Zaizai
 * @Date 2020/8/11 1:42 下午
 **/
@AdvancedFeignClient
public interface RemoteActivityCustomConfigService {

    /**
     * 根据活动id获取活动定制配置信息
     * @param activityId
     * @return
     */
    ActivityCustomConfigDto getByActivityId(Long activityId);

    /**
     * 保存或更新活动定制配置
     * @param activityCustomConfigDto
     * @return
     */
    Boolean saveOrUpdateActivityCustomConfig(ActivityCustomConfigDto activityCustomConfigDto);

    /**
     * 根据活动id删除定制配置
     * @param activityId
     * @return
     */
    Boolean deleteByActivityId(Long activityId);

}
