package cn.com.duiba.tuia.activity.center.api.bean.enums.adx;

import lombok.*;
import lombok.experimental.Accessors;
import org.jetbrains.annotations.NotNull;
import java.util.*;

/**
 * { Adx 广告位 } 类型规格
 * 注: 标记魅族 Adx 广告位类型及规格
 * @dateTime 2019-10-25 10:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum MeizuSpecEnum {

    /*################################# 标记魅族 Adx 广告位类型及规格的枚举 ( Start ) #####################################*/

    Banner("001", "横幅", null, 11, 1.1, "横幅大图", 200, "JPG/PNG", 1, 984, 420),
    InfoFlow("003", "信息流", 24, 22, 2.2, "信息流大图", 200, "JPG/PNG", 1, 984, 420),
    OpenScreen("002", "开屏", null, 31, 3.1, "开屏非下载类大图", 200, "JPG/PNG", 1, 1080, 1920);

    /*################################# 标记魅族 Adx 广告位类型及规格的枚举 ( end ) #######################################*/

    /*
     * 标识码
     */
    @Getter
    private String code;

    /*
     *「 Dsp 」广告类型名称
     */
    @Getter
    private String specName;

    /*
     * 标题限制字数
     */
    @Getter
    private Integer titleLimit;

    /*
     * 规格样式
     * 注: 取值依据是广告样式值去初 "小数点" 后的值 ( 取值依据只对本次有效 ).
     * 如: 广告样式值 : 1.1 <> 规格样式值 : 11
     */
    @Getter
    private Integer styleStandard;

    /*
     * 广告样式
     * 注: 取值依据是魅族提供的广告类型一致 ( 取值依据只对本次有效 ).
     */
    @Getter
    private Double template;

    /*
     * 广告样式描述
     */
    @Getter
    private String templateDescription;

    /*
     * 素材大小 ( 单位 : KB )
     */
    @Getter
    private Integer size;

    /*
     * 素材格式 ( 如 : Jpg , Png 等 )
     */
    @Getter
    private String picType;

    /*
     * 素材个数
     */
    @Getter
    private Integer picNumber;

    /*
     * 素材宽度
     */
    @Getter
    private Integer picWidth;

    /*
     * 素材高度
     */
    @Getter
    private Integer picHigh;


    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static MeizuSpecEnum seekValue(String code) {
        Optional<MeizuSpecEnum> result = Arrays.stream(MeizuSpecEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(null);
    }

    /**
     * 是否存在
     * @param code 标识码
     * @return 结果
     */
    @NotNull
    public static Boolean isExist(String code) {
        return Objects.nonNull(seekValue(code));
    }

}
