/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.dto.subtitle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SubDTO
implements Serializable {
    public static String ALGO_MD5_SIGN = "algoMd5Sign";
    public static String SALT_MD5 = "\u7ec4\u4ef6\u5316\u76d0\u503c\uff0c\u731c\u4e0d\u5230";
    private Long activityId;
    private List<Long> prizeIds;
    private Map<Long, String> advertIdMap;
    private Long mainTitleId;
    private Long subTitleId;

    public static String getAlgoMd5Sign(SubDTO dto) {
        if (null == dto) {
            return "";
        }
        StringBuilder sb = new StringBuilder("sub");
        sb.append(dto.activityId).append(CollectionUtils.isEmpty(dto.prizeIds) ? "" : JSON.toJSONString(dto.prizeIds)).append(null == dto.mainTitleId ? "" : dto.mainTitleId).append(null == dto.getSubTitleId() ? "" : dto.getSubTitleId());
        if (MapUtils.isNotEmpty(dto.getAdvertIdMap())) {
            ArrayList idList = Lists.newArrayList(dto.getAdvertIdMap().keySet());
            Collections.sort(idList);
            sb.append(idList);
        }
        return DigestUtils.md5Hex((String)(sb.toString() + SALT_MD5));
    }

    public static String getUrlParam(SubDTO subDTO) throws UnsupportedEncodingException {
        if (null == subDTO) {
            return "";
        }
        Map<Long, String> advertIdMap = subDTO.getAdvertIdMap();
        String advertIdStr = "";
        if (MapUtils.isNotEmpty(advertIdMap)) {
            advertIdStr = JSON.toJSONString(advertIdMap);
        }
        StringBuilder sb = new StringBuilder();
        if (null != subDTO.getMainTitleId()) {
            sb.append("mainTitleId=").append(subDTO.getMainTitleId());
        }
        if (null != subDTO.getSubTitleId()) {
            sb.append("&subTitleId=").append(subDTO.getSubTitleId());
        }
        if (CollectionUtils.isNotEmpty(subDTO.getPrizeIds())) {
            sb.append("&prizeIds=").append(SubDTO.getStringFromList(subDTO.getPrizeIds()));
        }
        if (StringUtils.isNotEmpty((CharSequence)advertIdStr)) {
            sb.append("&advertIdMap=").append(URLEncoder.encode(advertIdStr, "UTF-8"));
        }
        String algoMd5Sign = SubDTO.getAlgoMd5Sign(subDTO);
        sb.append("&algoMd5Sign=").append(algoMd5Sign);
        return sb.toString();
    }

    public static Map<Long, String> getAdvertIdMapFromStr(String advertIdStr) throws Exception {
        HashMap<Long, String> mapRes = new HashMap<Long, String>();
        if (StringUtils.isEmpty((CharSequence)advertIdStr)) {
            return mapRes;
        }
        String decode = URLDecoder.decode(advertIdStr, "UTF-8");
        decode = decode.replaceAll("&quot;", "\"");
        JSONObject parseObj = (JSONObject)JSON.parse((String)decode);
        for (String str : parseObj.keySet()) {
            mapRes.put(Long.valueOf(str), Optional.ofNullable(parseObj.get((Object)str)).orElse("") + "");
        }
        return mapRes;
    }

    public static String getStringFromList(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return "";
        }
        return StringUtils.join(ids, (String)",");
    }

    public static List<Long> getListFromString(String idStr) {
        if (StringUtils.isEmpty((CharSequence)idStr)) {
            return new ArrayList<Long>();
        }
        String[] split = idStr.split(",");
        return Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public List<Long> getPrizeIds() {
        return this.prizeIds;
    }

    public Map<Long, String> getAdvertIdMap() {
        return this.advertIdMap;
    }

    public Long getMainTitleId() {
        return this.mainTitleId;
    }

    public Long getSubTitleId() {
        return this.subTitleId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public void setPrizeIds(List<Long> prizeIds) {
        this.prizeIds = prizeIds;
    }

    public void setAdvertIdMap(Map<Long, String> advertIdMap) {
        this.advertIdMap = advertIdMap;
    }

    public void setMainTitleId(Long mainTitleId) {
        this.mainTitleId = mainTitleId;
    }

    public void setSubTitleId(Long subTitleId) {
        this.subTitleId = subTitleId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubDTO)) {
            return false;
        }
        SubDTO other = (SubDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$activityId = this.getActivityId();
        Long other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !((Object)this$activityId).equals(other$activityId)) {
            return false;
        }
        List<Long> this$prizeIds = this.getPrizeIds();
        List<Long> other$prizeIds = other.getPrizeIds();
        if (this$prizeIds == null ? other$prizeIds != null : !((Object)this$prizeIds).equals(other$prizeIds)) {
            return false;
        }
        Map<Long, String> this$advertIdMap = this.getAdvertIdMap();
        Map<Long, String> other$advertIdMap = other.getAdvertIdMap();
        if (this$advertIdMap == null ? other$advertIdMap != null : !((Object)this$advertIdMap).equals(other$advertIdMap)) {
            return false;
        }
        Long this$mainTitleId = this.getMainTitleId();
        Long other$mainTitleId = other.getMainTitleId();
        if (this$mainTitleId == null ? other$mainTitleId != null : !((Object)this$mainTitleId).equals(other$mainTitleId)) {
            return false;
        }
        Long this$subTitleId = this.getSubTitleId();
        Long other$subTitleId = other.getSubTitleId();
        return !(this$subTitleId == null ? other$subTitleId != null : !((Object)this$subTitleId).equals(other$subTitleId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : ((Object)$activityId).hashCode());
        List<Long> $prizeIds = this.getPrizeIds();
        result = result * 59 + ($prizeIds == null ? 43 : ((Object)$prizeIds).hashCode());
        Map<Long, String> $advertIdMap = this.getAdvertIdMap();
        result = result * 59 + ($advertIdMap == null ? 43 : ((Object)$advertIdMap).hashCode());
        Long $mainTitleId = this.getMainTitleId();
        result = result * 59 + ($mainTitleId == null ? 43 : ((Object)$mainTitleId).hashCode());
        Long $subTitleId = this.getSubTitleId();
        result = result * 59 + ($subTitleId == null ? 43 : ((Object)$subTitleId).hashCode());
        return result;
    }

    public String toString() {
        return "SubDTO(activityId=" + this.getActivityId() + ", prizeIds=" + this.getPrizeIds() + ", advertIdMap=" + this.getAdvertIdMap() + ", mainTitleId=" + this.getMainTitleId() + ", subTitleId=" + this.getSubTitleId() + ")";
    }
}

