package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 创意投放方式，0:依次投放,1:按比例投放
 *
 * @author hillchen
 * @create 2019/2/24 14:38
 */
public enum PutType {
    ORDER(0, "依次投放", 1),
    PROPORTION(1, "按比例投放", 0),
    ALGORITHM(2, "按算法投放", 0),
    ALGORITHM_PLUS(3, "按算法投放2.0", 0),
    ALGORITHM_PLUS_FOUR(4, "按算法投放3.0", 0);

    private Integer type;
    private String desc;
    private Integer defaultPut;

    PutType(Integer type, String desc, Integer defaultPut) {
        this.type = type;
        this.desc = desc;
        this.defaultPut = defaultPut;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getDefaultPut() {
        return defaultPut;
    }

    public void setDefaultPut(Integer defaultPut) {
        this.defaultPut = defaultPut;
    }

    public boolean isSameType(Integer type) {
        return type != null && Objects.equals(type, this.type);
    }

    public static boolean hasPutType(Integer type) {
        if (type != null) {
            for (PutType priceType : PutType.values()) {
                if (priceType.isSameType(type)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static PutType get(Integer type) {
        for (PutType putType : PutType.values()) {
            if (putType.getType() == type) {
                return putType;
            }
        }
        return PutType.ORDER;
    }

    public static boolean contains(Integer putType) {
        if (putType == null) {
            return false;
        }
        for (PutType putType1 : PutType.values()) {
            if (putType1.getType().equals(putType)) {
                return true;
            }
        }
        return false;
    }
}
