/**
 * Copyright (c) 2018, Ysoul. All rights reserved.
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.dto.req.VirtualContext;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 类描述: 活动发奖订单 用户端/管理端 公用
 *
 * @author <a href="651850874@qq.com">Ysoul</a>
 * @version 1.0 2018-01-16
 * @since 1.0
 */
public class ActivityWinOrderDto implements Serializable {
    private static final long serialVersionUID = 7604368514997525669L;

    private Long id;
    private String orderId;
    private String aliOrderId;
    private Long appId;
    private Long slotId;
    private String deviceId;
    private Long activityId;
    private Integer activityType;
    private Integer orderType;
    private Long prizeId;
    private String prizeTitle;

    /**
     * @see cn.com.duiba.tuia.activity.center.api.constant.OrderAlipayType 订单类型
     */
    private Integer alipayType;
    private String aliAccount;
    private String aliName;
    private String shippingAddress;
    private Integer awardAmount;
    private Integer status;
    private String resultCode;
    private String resultMsg;
    private String remark;
    private String expressNumber;
    private String express;
    private String extInfo;
    private Date createDate;
    private Date gmtCreate;
    private Date gmtModified;

    /**
     * 奖品类型
     */
    private String prizeType;

    /**
     * 奖品类型str
     */
    private String prizeTypeStr;

    /**
     * 券码(扩展信息)
     */
    private String code;

    /**
     * 券密码(扩展信息)
     */
    private String password;

    /**
     * 券信息
     * 券码，券密码，券链接
     */
    private CouponsCodeDto coupon;

    /**
     * 奖品价值
     */
    private String prizeWorth;

    //key--文案，value--填写内容，type--文案类型
    private List<VirtualContext> contextArray;

    /** 数值充值定额或随机类型 */
    private Integer prizeScoreType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getAliOrderId() {
        return aliOrderId;
    }

    public void setAliOrderId(String aliOrderId) {
        this.aliOrderId = aliOrderId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeTitle() {
        return prizeTitle;
    }

    public void setPrizeTitle(String prizeTitle) {
        this.prizeTitle = prizeTitle;
    }

    public Integer getAlipayType() {
        return alipayType;
    }

    public void setAlipayType(Integer alipayType) {
        this.alipayType = alipayType;
    }

    public String getAliAccount() {
        return aliAccount;
    }

    public void setAliAccount(String aliAccount) {
        this.aliAccount = aliAccount;
    }

    public String getAliName() {
        return aliName;
    }

    public void setAliName(String aliName) {
        this.aliName = aliName;
    }

    public String getShippingAddress() {
        return shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Integer getAwardAmount() {
        return awardAmount;
    }

    public void setAwardAmount(Integer awardAmount) {
        this.awardAmount = awardAmount;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultMsg() {
        return resultMsg;
    }

    public void setResultMsg(String resultMsg) {
        this.resultMsg = resultMsg;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getExpressNumber() {
        return expressNumber;
    }

    public void setExpressNumber(String expressNumber) {
        this.expressNumber = expressNumber;
    }

    public String getExpress() {
        return express;
    }

    public void setExpress(String express) {
        this.express = express;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getPrizeTypeStr() {
        return prizeTypeStr;
    }

    public void setPrizeTypeStr(String prizeTypeStr) {
        this.prizeTypeStr = prizeTypeStr;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CouponsCodeDto getCoupon() {
        return coupon;
    }

    public void setCoupon(CouponsCodeDto coupon) {
        this.coupon = coupon;
    }

    public String getPrizeWorth() {
        return prizeWorth;
    }

    public void setPrizeWorth(String prizeWorth) {
        this.prizeWorth = prizeWorth;
    }

    public List<VirtualContext> getContextArray() {
        return contextArray;
    }

    public void setContextArray(List<VirtualContext> contextArray) {
        this.contextArray = contextArray;
    }

    public Integer getPrizeScoreType() {
        return prizeScoreType;
    }

    public void setPrizeScoreType(Integer prizeScoreType) {
        this.prizeScoreType = prizeScoreType;
    }

    public static class GuidePageMoneyExtInfo implements Serializable {
        private static final long serialVersionUID = 2625456492854873153L;

        private Long fee;

        private String orderId;

        private Long userId;

        public Long getFee() {
            return fee;
        }

        public void setFee(Long fee) {
            this.fee = fee;
        }

        public String getOrderId() {
            return orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public Long getUserId() {
            return userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }
    }
}
