package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.DynamicEffectDTO;
import cn.com.duiba.tuia.activity.center.api.dto.DynamicEffectFindDTO;
import cn.com.duiba.tuia.activity.center.api.dto.DynamicEffectSaveDTO;
import cn.com.duiba.tuia.activity.center.api.dto.DynamicEffectSearchDTO;


/**
 * 特殊动效
 */
@AdvancedFeignClient
public interface RemoteDynamicEffectService {

    /**
     * 保存特殊动效
     *
     * @param dto
     * @return
     */
    Long saveDynamicEffect(DynamicEffectSaveDTO dto);

    /**
     * 分页查询特殊动效列表
     * @param dto
     * @return
     */
    PageDto<DynamicEffectDTO> selectByPage(DynamicEffectFindDTO dto);

    /**
     * 分页搜索特殊动效列表
     * @param dto
     * @return
     */
    PageDto<DynamicEffectDTO> searchByPage(DynamicEffectSearchDTO dto);

    /**
     * 根据id查询特殊动效
     * @param id
     * @return
     */
    DynamicEffectDTO getById(Long id);

}
