/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.story.tree;

import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public enum TreeLevelEnum {
    LV1(1, 0, 2, "\u5e7c\u82d71"),
    LV2(2, 10, 3, "\u5e7c\u82d72"),
    LV3(3, 30, 4, "\u6210\u957f1"),
    LV4(4, 50, 5, "\u6210\u957f2"),
    LV5(5, 70, 6, "\u6210\u719f\u671f"),
    LV6(6, 100, 7, "\u5b8c\u5168\u4f53");

    public static final int MAX_EXP = 100;
    private Integer level;
    private Integer exp;
    private Integer fruitAmount;
    private String statusDesc;

    private TreeLevelEnum(Integer level, Integer exp, Integer fruitAmount, String statusDesc) {
        this.level = level;
        this.exp = exp;
        this.fruitAmount = fruitAmount;
        this.statusDesc = statusDesc;
    }

    public Integer getLevel() {
        return this.level;
    }

    public Integer getExp() {
        return this.exp;
    }

    public Integer getFruitAmount() {
        return this.fruitAmount;
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public static TreeLevelEnum calLevel(int exp) {
        TreeLevelEnum[] levels = TreeLevelEnum.values();
        CollectionUtils.reverseArray((Object[])levels);
        for (TreeLevelEnum level : levels) {
            if (exp < level.getExp()) continue;
            return level;
        }
        return LV1;
    }

    public static TreeLevelEnum valueOf(Integer level) {
        for (TreeLevelEnum levelEnum : TreeLevelEnum.values()) {
            if (!Objects.equals(levelEnum.getLevel(), level)) continue;
            return levelEnum;
        }
        return null;
    }

    public static Integer upgradeExp(int level) {
        if (level == LV6.getLevel()) {
            return 100;
        }
        TreeLevelEnum levelEnum = TreeLevelEnum.valueOf(level + 1);
        return null != levelEnum ? levelEnum.getExp() : 100;
    }
}

