package cn.com.duiba.tuia.activity.center.api.dto.adx.unit;
/**
 * Copyright (c) 2021, Ysoul. All rights reserved.
 */

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 类描述: 创意素材DTO
 *
 * @author <a href="651850874@qq.com">Ysoul</a>
 * @version 1.0 2021-03-26
 * @since 1.0
 */

@Data
public class MaterialUnitDTO implements Serializable {

    private Long id;
    private String unitName;
    private String unitDesc;
    private Integer unitType;
    private String materialJson;
    private Integer unitStatus;
    private Integer isDeleted;
    private String unitSize;
    private Integer rateType;
    private Integer styleType;
    private Integer isDirectIdea;
    private Long directIdeaId;
    private Date gmtCreate;
    private Date gmtModified;

    private List<MaterialDetailDto> materialDetailDtoList;

    public List<Long> getMaterialIdList() {
        if (StringUtils.isBlank(materialJson)) {
            return Lists.newArrayList();
        }
        List<JSONObject> list = JSONObject.parseArray(materialJson, JSONObject.class);
        List<Long> materialIdList = Lists.newArrayList();
        for (JSONObject jsonObject : list) {
            materialIdList.add(jsonObject.getLongValue("materialId"));
        }
        return materialIdList;
    }

    public void buildMaterialDetail() {
        if (StringUtils.isBlank(materialJson)) {
            return;
        }
        this.setMaterialDetailDtoList(JSONObject.parseArray(materialJson, MaterialDetailDto.class));
    }

}
