package cn.com.duiba.tuia.activity.center.api.log;

import cn.com.duiba.tuia.activity.center.api.constant.AppFlowTypeEnum;
import cn.com.duiba.tuia.activity.center.api.constant.SlotDockingTypeEnum;
import cn.com.duiba.tuia.activity.center.api.log.annotation.UnderlineFiledLog;
import lombok.Data;

import java.io.Serializable;

/**
 * 统一维护
 * 全链路日志 字段对象
 * @author miaohongshuai
*/
@Data
public class FullLinkLog implements Serializable {

    private static final long serialVersionUID = -5484786522241537889L;

    /**
     * 数据接入方式标识
     * slotInterBigType：新版SDK=1，新版API、素材API、广告位链接、展示API、互动直投API	=2，ADX=3，讯飞类-广告位链接拼接设备号=4
     * slotInterSmallType：新版SDK=1、新版API=1，素材API=2、广告位链接=3、展示API=4、互动直投API=5，ADX=1，讯飞类-广告位链接拼接设备号=1
     * Fk：广告位投放链接，媒体只回传device_id=1，通过设备号更新deviceId=2，推啊生成deviceId=3
     * actMainTitleId：活动主标题ID
     * actSubTitleId： 活动副标题ID
     * actPageMainTitleId：自定义活动主标题ID
     * actPageSubTitleId：自定义活动副标题ID
     * actTitleActualPutType：活动标题实际投放类型 0-人工图片标题 1-人工配置标题 2-算法推荐标题
     * slotTitleTheoryPutType：活动标题理论投放类型 1-人工标题 2-算法标题
     * slotInterBigType：新版SDK、老版SDK=1，新版API、广告位链接、展示API、互动直投API =2，ADX=3，讯飞类-广告位链接拼接设备号、原生类--广告位链接拼接设备号=4
     * slotInterSmallType：新版SDK、新版API、ADX、讯飞类-广告位链接拼接设备号=1，老版SDK、原生类--广告位链接拼接设备号=2、广告位链接=3、展示API=4、互动直投API=5
     * Fk：广告位投放链接，媒体只回传device_id=1，通过设备号更新deviceId=2，推啊生成deviceId=3
     * packageName:sdk上传的应用包名
     * 需求文档：http://cf.dui88.com/pages/viewpage.action?pageId=43759568
     */
    private String slotInterBigType;
    private String slotInterSmallType;
    private String Fk;

    @UnderlineFiledLog
    private String actMainTitleId;
    @UnderlineFiledLog
    private String actSubTitleId;
    @UnderlineFiledLog
    private String actPrizeId;

    @UnderlineFiledLog
    private String actPageMainTitleId;
    @UnderlineFiledLog
    private String actPageSubTitleId;
    @UnderlineFiledLog
    private String actPagePrizeId;

    @UnderlineFiledLog
    private String actTitleActualPutType;
    @UnderlineFiledLog
    private String slotTitleTheoryPutType;
    /**
     *  系统来源 Android/IOS
     */
    private String osType;

    /**
     * SDK A/B测试类型，为关时，不拼接，或拼接固定值（如test_type=0）为开时，拼接为 test_type=a 或者 test_type=b；
     */
    private String testType;

    /**插件出行业弹层日志
     */
    private String pluginTags;
    private String pluginTagLayerIds;

    private String packageName;

    /** 活动副标题奖品ID */
    private String actSubTitlePrizeId;
    /** 自定义活动副标题奖品ID */
    private String actPageSubTitlePrizeId;
    /** 活动奖品实际投放类型
     0：兜底（人工默认或算法异常时）
     1：人工随机
     2：算法推荐
     */
    private String actPrizeActualPutType;

    /**
     * 返回拦截投放类型 1-人工；2-算法；3-盘古；
     * 需求地址：http://cf.dui88.com/pages/viewpage.action?pageId=51167985
     */
    @UnderlineFiledLog
    private String interceptActivityWay;

    //SDK广告位理论接入类型  0：互动广告 1：展示广告 2：原生互动广告 3：互动直投 4：互动广告+互动直投混投
    private String SdkSlotTheoryAccessType;

    // SDK广告位实际接入类型 0：互动广告 3：互动直投
    private String SdkSlotActualAccessType;

    //new api sdkversion
    private String newSdkVersion;

    /** 返回拦截内容类型，1：活动，2：插件，3：落地页 */
    @UnderlineFiledLog
    private String interceptContentType;
    /** 返回拦截内容id */
    @UnderlineFiledLog
    private String interceptContentId;

    /** SDK tcid*/
    private String tcid;

    /** 活动引擎 openStyleType*/
    private String openStyleType;

    /** 联通用户发券类型
     1 联通用户 第一次 补发免费券
     2 非联通用户 第一次 补发免费券
     3 扣分券
     4 联通 非第一次补发 免费券
     5 非联通 非第一次补发 免费券 */
    @UnderlineFiledLog
    private String unicomLaunchType;

    /* 虚拟流量 0/null-否;1-是; */
    private Integer isOutside;

    /** 素材来源 5-实验组;6-对照组; */
    private Integer sckFromType;

    /** 素材ID 0/null-否;1-是; */
    private Long sckId;

    /** 活动补打日志参数 */
    private String actPreloadingParam;

    /** abtest日志打印
     * List<cn.com.duiba.tuia.activity.center.api.log.ABTestLog>
     * */
    private String abtest;

    /**
     * 媒体referer中的host
     */
    @UnderlineFiledLog
    private String appHost;

    /**
     * dp算法命中状态 0-走原大盘活动 1-走dp唤醒广告
     */
    @UnderlineFiledLog
    private String dpAlgoStatus;

    /**
     * 全链路新增字段（广告位对接类型）
     * {@link SlotDockingTypeEnum}
     */
    @UnderlineFiledLog
    private Integer slotDockingType;

    /**
     * 媒体定向投放时 给到数据这边反向清洗标签用
     */
    private String dmpTag;

    /**
     * 流量类型
     * @see AppFlowTypeEnum
     */
    private String appFlowType;

    /**
     * 唯一标识openid
     * CF:http://cf.dui88.com/pages/viewpage.action?pageId=99956844
     */
    private String tuiaOpenId;
    /**
     * 唯一标识openid(变更公众号之后的上一个openid)
     * CF:http://cf.dui88.com/pages/viewpage.action?pageId=99956844
     */
    private String tuiaOldOpenId;
    /**
     * 唯一标识openid的数据来源
     * {@link cn.com.duiba.tuia.activity.center.api.constant.TuiaOpenTypeEnum}
     */
    private Integer tuiaOpenType;

    /**
     * 媒体回传唯一Id
     */
    private String mcbId;

    /**
     * 媒体回传标签
     */
    private String dkp_list;

    /**
     * 广告位访问 服务端开始处理请求时间戳
     * 目前仅快应用用来解决收益降低，过滤耗时较长用户不加载快应用
     */
    private Long slotAccessProcessingTime;

    /**
     * 推啊全局唯一标识
     * CF:http://cf.dui88.com/pages/viewpage.action?pageId=105100176
     */
    private String oneId;
    /**
     * oneId的类型: 1:真实设备号，2：虚拟设备号
     */
    private Integer oneIdType;

    private String engine_host;
}
