package cn.com.duiba.tuia.activity.center.api.constant.commercial.common;

import java.util.Objects;

/**
 * TODO 注释
 *
 * @author zhangbaiqiang
 * @date 2019-04-24
 */
public enum BizActivityType {

    UNDEFINED(0, "未定义"),
    PLANT(1, "种红包"),
    DIG(2, "挖矿"),
    ;

    private Integer type;
    private String desc;

    BizActivityType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        for (BizActivityType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getDesc();
            }
        }
        return null;
    }
}
