package cn.com.duiba.tuia.activity.center.api.dto.reward.config;

import java.io.Serializable;
import java.util.Map;

/**
 * 激励互动奖励配置
 *
 * @author zhangbaiqiang
 * @date 2019-07-14
 */
public class RewardedActivityPrizeConfig implements Serializable {
    private static final long serialVersionUID = -7008896281301077095L;

    /**
     * 时间戳
     */
    private Long timestamp;

    /**
     * 默认奖品id
     */
    private Long defaultPrizeId;

    /**
     * 默认奖品名称
     */
    private String defaultPrizeTitle;

    /**
     * 奖励最少参与次数
     */
    private Integer minRewardedTimes;

    /**
     * 奖励最多参与次数
     */
    private Integer maxRewardedTimes;

    /**
     * 返回拦截激励视频奖励
     */
    private RewardedActivitySrpVideoPrizeDetail srpVideo;

    /**
     * 活动参与奖励明细
     */
    private Map<Integer, RewardedActivityPrizeDetail> prize;

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getDefaultPrizeId() {
        return defaultPrizeId;
    }

    public void setDefaultPrizeId(Long defaultPrizeId) {
        this.defaultPrizeId = defaultPrizeId;
    }

    public String getDefaultPrizeTitle() {
        return defaultPrizeTitle;
    }

    public void setDefaultPrizeTitle(String defaultPrizeTitle) {
        this.defaultPrizeTitle = defaultPrizeTitle;
    }

    public Integer getMinRewardedTimes() {
        return minRewardedTimes;
    }

    public void setMinRewardedTimes(Integer minRewardedTimes) {
        this.minRewardedTimes = minRewardedTimes;
    }

    public Integer getMaxRewardedTimes() {
        return maxRewardedTimes;
    }

    public void setMaxRewardedTimes(Integer maxRewardedTimes) {
        this.maxRewardedTimes = maxRewardedTimes;
    }

    public RewardedActivitySrpVideoPrizeDetail getSrpVideo() {
        return srpVideo;
    }

    public void setSrpVideo(RewardedActivitySrpVideoPrizeDetail srpVideo) {
        this.srpVideo = srpVideo;
    }

    public Map<Integer, RewardedActivityPrizeDetail> getPrize() {
        return prize;
    }

    public void setPrize(Map<Integer, RewardedActivityPrizeDetail> prize) {
        this.prize = prize;
    }
}
