package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.ResourceLocationOtherDataDTO;
import cn.com.duiba.tuia.activity.center.api.dto.adx.AdxSlotDataSyncDto;

import java.util.List;
import java.util.Set;

/**
 * adx数据服务
 *
 * @author weny.cai
 * @date 2019/2/25 10:46
 **/
@AdvancedFeignClient
public interface RemoteAdxDiService {

    /**
     * 获得前一天
     * 广告位ADX数据
     * @return
     */
    List<AdxSlotDataSyncDto> getPreDaySlotDi(String curDate);

    /**
     * 获取资源位不常用的扩展数据(不聚合在数据DiDTO中，影响想能)
     *
     * @param resourceLocationId
     * @return
     */
    ResourceLocationOtherDataDTO getResourceLocationExtData(Long resourceLocationId);

    /**
     * 根据推广组
     * @param grouIds
     * @return
     */
    Set<Long> listResourceIdeaId(List<Long> grouIds);

}
