package cn.com.duiba.tuia.activity.center.api.dto.adx.unit.filter;

import cn.com.duiba.tuia.activity.center.api.bean.enums.adx.TuiaStyleTypeEnum;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 描述: 由于现在只支持单图、单视频，顾有此easy style对象
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/4/19 11:37
 */
@Data
public class UnitEasyStyle implements Serializable {
    private static final long serialVersionUID = -2447098622625895432L;

    private TuiaStyleTypeEnum styleTypeEnum;

    private Integer materialType;

    private Integer ratioType;

    private Integer width;

    private Integer height;

    public UnitEasyStyle(MaterialUnitFilterCondition unitFilter) {
        if (unitFilter != null) {
            List<MaterialUnitDetailFilter> materialUnitDetailFilterList = unitFilter.getMaterialUnitDetailFilterList();
            if (CollectionUtils.isNotEmpty(materialUnitDetailFilterList)) {
                MaterialUnitDetailFilter materialUnitDetailFilter = materialUnitDetailFilterList.get(0);
                this.setStyleTypeEnum(unitFilter.getTuiaStyleTypeEnum());
                this.setMaterialType(materialUnitDetailFilter.getMaterialType());
                this.setWidth(materialUnitDetailFilter.getWidth());
                this.setHeight(materialUnitDetailFilter.getHeight());
            }
        }
    }

    public boolean isEmpty() {
        return styleTypeEnum == null;
    }


}