package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityPluginWarnDto;

import java.util.List;

/**
 * @ClassName RemotePluginWarnService
 * @Description 插件告警
 * @Author Zaizai
 * @Date 2020/11/3 3:14 下午
 **/
@AdvancedFeignClient
public interface RemotePluginWarnService {

    /**
     * 查询开启了告警配置的插件id
     * @param pluginIds
     * @return
     */
    List<Long> selectOpenWarningPlugins(List<Long> pluginIds);

    /**
     * 获取告警配置信息
     * @param pluginId
     * @return
     */
    ActivityPluginWarnDto getPluginWarnDetail(Long pluginId);

    /**
     * 分页查询开启告警的插件告警配置
     * @param pageIndex
     * @param pageSize
     * @return
     */
    PageDto<ActivityPluginWarnDto> selectOpenWarningByPage(Integer pageIndex, Integer pageSize);

    /**
     * 保存插件告警配置
     * @param activityPluginWarnDto
     * @return
     */
    Boolean saveActivityPluginWarnConfig(ActivityPluginWarnDto activityPluginWarnDto);

    /**
     * 删除插件告警
     * @param pluginId
     * @return
     */
    Boolean deleteByPluginId(Long pluginId);

    /**
     * 更新上次告警时间
     * @param pluginIds
     * @return
     */
    Boolean updateLastWarn(List<Long> pluginIds);
}
