package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.adx.unit.MaterialUnitDTO;

import java.util.List;

/**
 * 描述: 创意素材绑定服务
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/3/29 10:37
 */
@AdvancedFeignClient
public interface RemoteIdeaMaterialUnitService {

    /**
     * 查询创意计划绑定的创意素材
     *
     * @param ideaId
     * @return
     */
    List<MaterialUnitDTO> selectByIdeaId(Long ideaId);

    /**
     * 查询创意计划绑定的创意素材审核状态
     *
     * @param ideaId
     * @return
     */
    List<MaterialUnitDTO> selectAuditByIdeaId(Long ideaId);

    /**
     * 批量查询创意计划绑定的创意素材
     * @return
     */
    List<MaterialUnitDTO> selectByIdeaIds(List<Long> ideaIds);

    /**
     * 获取算法创意素材
     * @return
     */
    List<MaterialUnitDTO> selectDpaIdeas();

}
