package cn.com.duiba.tuia.activity.center.api.remoteservice.algo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.algo.AlgoTestPlanDTO;
import cn.com.duiba.tuia.activity.center.api.dto.algo.ReqAlgoTestPlan;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAlgoTestPlanService {
    /**
     *  测试计划列表列表
     */
    DubboResult<PageResultDto<AlgoTestPlanDTO>> listAlgoTestPlan(ReqAlgoTestPlan req);

    /**
     *  添加测试计划
     */
    DubboResult<Boolean> addAlgoTestPlan(AlgoTestPlanDTO dto);


    /**
     *  停止测试计划
     */
    DubboResult<Boolean> stopAlgoTestPlan(Long id, String operatorName);

    /**
     *  获取所有的subActivity
     */
    DubboResult<List<Integer>> allSubActivityWay();

    /**
     *  所有algoType
     */
    DubboResult<List<String>> listAlgoType();

    /**
     *  广告位计划个数
     */
    DubboResult<Long> existPlan(Long slotId);

    /**
     *  是否有大盘测试
     */
    DubboResult<Integer> countMarket();

    /**
     *  获取测试计划
     * @param type :{@link cn.com.duiba.tuia.activity.center.api.constant.algo.TestFlowTypeEnum}
     */
    DubboResult<AlgoTestPlanDTO> algoTestPlan(Integer type, Long slotId);

}
