package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.adx.AdxTypeEnum;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceLocationDto;
import cn.com.duiba.tuia.activity.center.api.dto.crowd.CrowdDataDTO;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceLocationPageReq;

import java.util.List;

/**
 * 资源位
 *
 * @author weny.cai
 * @date 2018/11/30 10:50
 **/
@AdvancedFeignClient
public interface RemoteResourceLocationService {

    boolean add(ResourceLocationDto resourceLocationDto) throws BizException;

    boolean update(ResourceLocationDto resourceLocationDto) throws BizException;

    String batchEdit(ResourceLocationDto resourceLocationDto) throws BizException;

    ResourceLocationDto getResourceLocationDto(Long id);
    ResourceLocationDto getResourceLocationForAdx(Long id);

    PageDto<ResourceLocationDto> pageQuery(ResourceLocationPageReq req);

    PageDto<ResourceLocationDto> specificSortPageQuery(ResourceLocationPageReq req);

    List<ResourceLocationDto> getAll();

    boolean changeSwitchStateById(Long id, Integer switchState);

    boolean batchChangeSwitchStateById(List<Long> idList, Integer switchState) throws BizException;

    boolean isExistPic(Long specId) throws BizException;

    boolean savePutType(Long sourceId, Integer putType);

    ResourceLocationDto getResourceByTagId(String tagId);

    /**
     * 根据媒体广告位id 和 adx类型查询资源位
     *
     * @param tagId    媒体广告位id
     * @param adxType  隶属于哪个adx {@link AdxTypeEnum#getType()}
     * @return
     */
    ResourceLocationDto getResourceByTagIdAndAdxType(String tagId, Integer adxType);

    Long getGroupIdByResourceId(Long resourceId);

    void deleteById(Long id) throws BizException;

    /**
     * 批量删除资源位
     * @param ids
     * @return
     * @throws BizException
     */
    String batchDeleteByIds(List<Long> ids) throws BizException;

    /**
     * 根据资源位Id查询关联第三方的广告位标识
     *
     * @param resourceLocationId 资源位Id
     * @return 返回集合
     */
    List<String> queryPosIdsById(Long resourceLocationId);

    /**
     * 根据第三方广告位Ids查询
     *
     * @param impIds
     * @return 返回推啊广告位Ids
     */
    List<String> getResourceIdsByImpIds(List<String> impIds);

    /**
     * 根据资源位主键获取资源位简化模型
     *
     * @param resourceLocationId 资源位Id
     * @return 资源位模型
     */
    ResourceLocationDto getSimpleResourceLocation(Long resourceLocationId);

    /**
     * 功能描述 根据广告位类型ID查询资源位是否存在
     * @author shenjiaqing
     * @date 13:54 2019/11/19
     * @param [adTypeId]
     * @return java.lang.Integer
     **/
    Integer resourceLocationIsExistsByAdTypeId(Long adTypeId);

    /** 条件查询资源位列表
     * 功能描述
     * @author shenjiaqing
     * @date 11:12 2020/5/12
     * @param [req]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceLocationDto>
     **/
    List<ResourceLocationDto> getResourceListByCondition(ResourceLocationPageReq req);

    /**
     * dmp人群定向包
     * @return
     */
    //todo: 待媒体人群包需求上线 crowdsList、adxCrowdsList、searchList、adxSearchList可删除
    List<CrowdDataDTO> crowdsList();

    /**
     * adx人群定向包
     * @return
     */
    List<CrowdDataDTO> adxCrowdsList();

    List<CrowdDataDTO> searchList(String word);

    List<CrowdDataDTO> adxSearchList(String word);

    /**
     * 查询所有在投的资源位列表
     * @return
     */
    List<ResourceLocationDto> getAllValid();

}
