/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.AdxMaterialUnitDataDTO;
import cn.com.duiba.tuia.activity.center.api.dto.adx.unit.MaterialUnitDTO;
import cn.com.duiba.tuia.activity.center.api.dto.adx.unit.MaterialUnitUpdateDTO;
import cn.com.duiba.tuia.activity.center.api.dto.req.MaterialUnitPageReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.MaterialUnitPageV2Req;
import cn.com.duiba.tuia.activity.center.api.req.adx.filter.MaterialUnitFilter;

import java.util.List;

/**
 * 描述: 创意素材服务
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/3/29 10:37
 */
@AdvancedFeignClient
public interface RemoteMaterialUnitService {

    /**
     * 查询
     *
     * @param id
     * @return
     */
    MaterialUnitDTO select(Long id);

    /**
     * 根据过滤器查询
     *
     * @param filter
     * @return
     */
    List<MaterialUnitDTO> filter(MaterialUnitFilter filter);

    /**
     * 分页
     *
     * @param req
     * @return
     */
    PageDto<MaterialUnitDTO> pageQuery(MaterialUnitPageReq req);

    /**
     * 分页
     *
     * @param req
     * @return
     */
    PageDto<MaterialUnitDTO> pageQueryV2(MaterialUnitPageV2Req req);

    /**
     * 分页查询查询素材数据
     * @param pageReq
     * @return
     */
    PageDto<AdxMaterialUnitDataDTO> queryMaterialDataByPage(MaterialUnitPageV2Req pageReq);

    /**
     * 根据list批量查询
     *
     * @param idList
     * @return
     */
    List<MaterialUnitDTO> selectByIdList(List<Long> idList);

    /**
     * 插入
     *
     * @param dto
     * @return
     */
    MaterialUnitDTO insert(MaterialUnitDTO dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    int update(MaterialUnitDTO dto);

    /**
     * 批量更新
     */
    int batchUpdate(MaterialUnitUpdateDTO updateDTO);

    /**
     * 查询全部
     *
     * @return
     */
    List<MaterialUnitDTO> getAll();

    /**
     * 初始化
     * @return
     */
    Boolean initAdxMaterialData();

}
