package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.PopularGroupDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.UpdatePreLoadAdvertDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.PopularGroupPageReq;

import java.util.List;

/**
 * 推广组服务
 *
 * @author weny.cai
 * @date 2018/11/29 14:55
 **/
@AdvancedFeignClient
public interface RemotePopularGroupService {

    boolean insert(PopularGroupDto dto) throws BizException;

    boolean update(PopularGroupDto dto) throws BizException;

    PageDto<PopularGroupDto> pageQuery(PopularGroupPageReq req);

    List<PopularGroupDto> getAll();

    boolean changeSwitchStateById(Long id,Integer switchState);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    PopularGroupDto selectById(Long id);

    /**
     * 删除
     * @param id
     */
    void deleteById(Long id) throws BizException;

    List<Integer> selectAdxTypeByParam(PopularGroupPageReq req);

    List<PopularGroupDto> selectPageByAdxType(Long id, String groupName, List<Integer> adxTypes);

    /**
     * 功能描述 批量开启/关闭某个推广组下的所有创意的预发券功能
     * @author shenjiaqing
     * @date 14:23 2019/12/30
     * @param dto
     * @return boolean
     **/
    boolean batchUpdatePreLoadAdvertStatus(UpdatePreLoadAdvertDto dto);

    List<Long> selectByAdxTypes(List<Integer> adxTypes);

}
