package cn.com.duiba.tuia.activity.center.api.remoteservice.crowd;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.constant.crowd.CrowdBindTypeEnum;
import cn.com.duiba.tuia.activity.center.api.dto.crowd.CrowdBindDTO;
import cn.com.duiba.tuia.activity.center.api.dto.crowd.CrowdDataDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCrowdBindService {

    /**
     * 新增人群定向关系
     *
     * @param dto
     * @return
     */
    Boolean addCrowdBind(CrowdBindDTO dto);

    /**
     * 修改人群定向关系
     *
     * @param dto
     * @return
     */
    Boolean updateCrowdBind(CrowdBindDTO dto);

    /**
     * 查找人群定向关系
     *
     * @param objectType
     * @param objectId
     * @param typeEnum
     * @return
     */
    CrowdBindDTO findCrowdBind(Integer objectType, Long objectId, CrowdBindTypeEnum typeEnum);

    /**
     * 人群定向包
     * @return
     */
    List<CrowdDataDTO> crowdsList(Integer crowdType, String searchWord);


}
