package cn.com.duiba.tuia.activity.center.api;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.math.RandomUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * ClassName: ActivityEntity <br/>
 * Function: 活动实体类. <br/>
 * date: 2017年3月14日 上午10:33:07 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class ActivityEntityDto {

    private static final long serialVersionUID = 5285040027355875660L;

    private Long              id;

    /**
     * 主标题id
     */
    private Long           titleFirstId ;
    /**
     * 副标题id
     */
    private Long           titleSecondId ;
    /**
     * 主标题名称
     */
    private String           titleFirstName ;
    /**
     * 副标题名称
     */
    private String           titleSecondName ;

    private Boolean           isDeleted;

    /** title:活动标题. */
    private String            title;

    /** activityType:活动类型. */
    private Integer           activityType;

    /** subType:活动子类型（皮肤类型）. */
    private String            subType;

    /** limitCount:限制次数. */
    private Integer           limitCount;

    /** limitScope:限制范围. */
    private String            limitScope;

    /** tag:标签. */
    private String            tag;

    /** activityPlanner:活动策划. */
    private String            activityPlanner;

    /** visionPlanner:视觉策划. */
    private String            visionPlanner;

    /** urlInfo:图片url. */
    private String            urlInfo;

    /** isBuoy:是否开启浮标. */
    private Boolean           isBuoy;

    /** numBuoy:浮标展示频次. */
    private Integer           numBuoy;

    /** daysBuoy:浮标出现天数。*/
    private String            daysBuoy;

    /** isOpen:是否开启,0/1 开启/关闭. */
    private Boolean           isOpen;

    /** autoOffDate:自动关闭时间. */
    private Date              autoOffDate;

    /** buoyId:活动关联的浮标id. */
    private Long              buoyId;

    /** overseas:海外标识，0／1 国内/海外. */
    private Integer           overseas;

    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 审核消息
     */
    private String auditMsg;

    /**
     * 审核图片
     */
    private String auditUrl;

    /**
     * 最后审核提交人
     */
    private Long lastManagerId;

    /**
     * 最后审核提交时间
     */
    private Date submitAuditTime;

    /**
     * 是否置顶
     */
    private Integer top;

    /**
     * 置顶更改时间
     */
    private Date topGmtModified;

    /**
     * 活动预览url
     */
    private String previewUrl;


    /**
     * 集卡活动次日自动清空
     */
    private Boolean isAutoClear;
    /**
     * 活动添加人
     */
    private Long creator;
    /**
     * 活动添加人 phone
     */
    private String creatorPhone;

    /**
     * 活动定制开关
     */
    private Integer openCustomization;

    private Integer rspPlugTimes;

    private String rspPlugIds;

    /**
     * 是否支持增值
     */
    private Boolean isEnc;
    /**
     * 是否是用户收藏活动
     */
    private Boolean isFavorite;

    private Long userId;

    /**
     * 优胜率（10000倍率）
     */
    private Long winningRate;

    /**
     * 表现优质广告位ID
     */
    private String slotIds;

    /**
     * 是否是高中奖率活动
     */
    private Integer isHighAwardRateActivity;

    /**
     * Creates a new instance of ActivityEntity.
     */
    public ActivityEntityDto() {
        super();
    }

    public String getDaysBuoy() {
        return daysBuoy;
    }

    public void setDaysBuoy(String daysBuoy) {
        this.daysBuoy = daysBuoy;
    }

    public Integer getOverseas() {
        return overseas;
    }

    public void setOverseas(Integer overseas) {
        this.overseas = overseas;
    }

    public Long getBuoyId() {
        return buoyId;
    }

    public void setBuoyId(Long buoyId) {
        this.buoyId = buoyId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType == null ? null : subType.trim();
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope == null ? null : limitScope.trim();
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag == null ? null : tag.trim();
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getActivityPlanner() {
        return activityPlanner;
    }

    public void setActivityPlanner(String activityPlanner) {
        this.activityPlanner = activityPlanner;
    }

    public String getVisionPlanner() {
        return visionPlanner;
    }

    public void setVisionPlanner(String visionPlanner) {
        this.visionPlanner = visionPlanner;
    }

    public String getUrlInfo() {
        return urlInfo;
    }

    public void setUrlInfo(String urlInfo) {
        this.urlInfo = urlInfo;
    }

    public Boolean getIsBuoy() {
        return isBuoy;
    }

    public void setIsBuoy(Boolean isBuoy) {
        this.isBuoy = isBuoy;
    }

    public Integer getNumBuoy() {
        return numBuoy;
    }

    public void setNumBuoy(Integer numBuoy) {
        this.numBuoy = numBuoy;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public Integer getAuditState() {
        return auditState;
    }

    public void setAuditState(Integer auditState) {
        this.auditState = auditState;
    }

    public String getAuditMsg() {
        return auditMsg;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public Long getLastManagerId() {
        return lastManagerId;
    }

    public void setLastManagerId(Long lastManagerId) {
        this.lastManagerId = lastManagerId;
    }

    public Date getSubmitAuditTime() {
        return submitAuditTime;
    }

    public void setSubmitAuditTime(Date submitAuditTime) {
        this.submitAuditTime = submitAuditTime;
    }

    public String getAuditUrl() {
        return auditUrl;
    }

    public void setAuditUrl(String auditUrl) {
        this.auditUrl = auditUrl;
    }

    public Integer getTop() {
        return top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public Date getTopGmtModified() {
        return topGmtModified;
    }

    public void setTopGmtModified(Date topGmtModified) {
        this.topGmtModified = topGmtModified;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public Boolean getIsAutoClear() {
        return isAutoClear;
    }

    public void setIsAutoClear(Boolean autoClear) {
        this.isAutoClear = autoClear;
    }

    public Integer getOpenCustomization() {
        return openCustomization;
    }

    public void setOpenCustomization(Integer openCustomization) {
        this.openCustomization = openCustomization;
    }

    public Integer getRspPlugTimes() {
        return rspPlugTimes;
    }

    public void setRspPlugTimes(Integer rspPlugTimes) {
        this.rspPlugTimes = rspPlugTimes;
    }

    public String getRspPlugIds() {
        return rspPlugIds;
    }

    public void setRspPlugIds(String rspPlugIds) {
        this.rspPlugIds = rspPlugIds;
    }

    public Boolean getIsEnc() {
        return isEnc;
    }

    public void setIsEnc(Boolean isEnc) {
        this.isEnc = isEnc;
    }

    public Boolean getIsFavorite() {
        return isFavorite;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(final Long creator) {
        this.creator = creator;
    }

    public String getCreatorPhone() {
        return creatorPhone;
    }

    public void setCreatorPhone(final String creatorPhone) {
        this.creatorPhone = creatorPhone;
    }

    public Long getTitleFirstId() {
        return titleFirstId;
    }

    public void setTitleFirstId(Long titleFirstId) {
        this.titleFirstId = titleFirstId;
    }

    public Long getTitleSecondId() {
        return titleSecondId;
    }

    public void setTitleSecondId(Long titleSecondId) {
        this.titleSecondId = titleSecondId;
    }

    public String getTitleFirstName() {
        return titleFirstName;
    }

    public void setTitleFirstName(String titleFirstName) {
        this.titleFirstName = titleFirstName;
    }

    public String getTitleSecondName() {
        return titleSecondName;
    }

    public void setTitleSecondName(String titleSecondName) {
        this.titleSecondName = titleSecondName;
    }

    public Long getWinningRate() {
        return winningRate;
    }

    public void setWinningRate(Long winningRate) {
        this.winningRate = winningRate;
    }

    public String getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(String slotIds) {
        this.slotIds = slotIds;
    }

    public Integer getIsHighAwardRateActivity() {
        return isHighAwardRateActivity;
    }

    public void setIsHighAwardRateActivity(Integer isHighAwardRateActivity) {
        this.isHighAwardRateActivity = isHighAwardRateActivity;
    }
}
