package cn.com.duiba.tuia.activity.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 落地页模板表
 * @author lijicong
 * @since 2021-07-08
 */
@Getter
@Setter
public class LandTemplateFormDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("")
    private Long id;

    @ApiModelProperty("落地页名称")
    private String title;

    @ApiModelProperty("落地页渠道")
    private String channel;

    @ApiModelProperty("1:删除，0:未删除")
    private Boolean isDeleted;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("网页名称")
    private String webName;

    @ApiModelProperty("自动下载：0-非，1-是")
    private Integer autoDownload;

    @ApiModelProperty("自动下载时间")
    private Integer autoDownloadTime;

    @ApiModelProperty("安卓下载地址")
    private String downloadAndriod;

    @ApiModelProperty("iOS下载地址")
    private String downloadIos;

    @ApiModelProperty("sso系统用户id")
    private Long ssoAeId;

    @ApiModelProperty("0:链接,1:弹层")
    private Integer autoDownloadType;

    @ApiModelProperty("落地页缩略图地址")
    private String thumbnailUrl;

    @ApiModelProperty("下载类型：0:非微信下载，1：微信下载")
    private Integer wxJump;

    @ApiModelProperty("落地页标签，多个逗号隔开")
    private String promoteTag;

    @ApiModelProperty("推广方式 0:微信")
    private Integer promotionWay;

    @ApiModelProperty("点击微信 0:复制成功弹窗 1:直接唤醒")
    private Integer clickWechat;

    @ApiModelProperty("页面html代码")
    private String html;

}