package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.constant.FieldNameSpace;
import cn.com.duiba.tuia.activity.center.api.dto.risk.AuditDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * ClassName: TuiaActivityDto <br/>
 * Function: 活动Dto. <br/>
 * date: 2017年2月24日 下午2:56:05 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.8
 */
@Data
public class TuiaActivityDto extends AuditDto {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1019469911189459013L;

    private Long              id;
    /** title:活动标题. */
    private String            title;
    /** activityType:活动type. */
    private Integer           activityType;
    /** skinName:皮肤名称. */
    private String            skinName;
    /** activityTypeName:活动类型名称. */
    private String            activityTypeName;
    /** subType:皮肤type. */
    private String            subType;
    /** limitCount:参与次数限制. */
    private Integer           limitCount;
    /** limitScope:限制类型(enum:LimitType). */
    private String            limitScope;
    /** tag:标签. */
    private String            tag;
    /** isDeleted:是否删除. */
    private Boolean           isDeleted;
    /** activityPlanner:活动策划. */
    private String            activityPlanner;
    /** visionPlanner:视觉策划. */
    private String            visionPlanner;
    /** bannerUrl:活动中心banner图. */
    private String            bannerUrl;
    /** recommendUrl:活动中心推荐位. */
    private String            recommendUrl;
    /** listUrl:活动中心列表url. */
    private String            listUrl;
    /** isBuoy:是否开启浮标. */
    private Boolean           isBuoy;
    /** numBuoy:浮标展示频次. */
    private Integer           numBuoy;
    /** isOpen:是否开启,0/1 开启/关闭. */
    private Boolean           isOpen;
    /** autoOffDate:自动关闭时间. */
    private Date              autoOffDate;
    /** buoyId:活动关联的浮标id. */
    private Long              buoyId;
    /** overseas:海外标识，0／1 国内/海外. */
    private Integer           overseas;

    private Boolean  notice = false;

    /**
     * 主标题id
     */
    private Long           titleFirstId ;
    /**
     * 副标题id
     */
    private Long           titleSecondId ;
    /**
     * 主标题名称
     */
    private String           titleFirstName ;
    /**
     * 副标题名称
     */
    private String           titleSecondName ;

    public Boolean getNotice() {
        return notice;
    }

    public void setNotice(Boolean notice) {
        this.notice = notice;
    }

    /**
     * 活动置顶
     */
    private Integer top;

    private Integer rcmd;

    private Date rcmdGmtModified;

    private Integer intercept;

    private Date interceptGmtModified;

    private Date              gmtCreate;

    private Date              gmtModified;

    /**
     * 置顶更改时间
     */
    private Date topGmtModified;

    /**
     * 活动预览链接
     */
    private String previewUrl;

    /**
     * 浮标出现天数
     */
    private String daysBuoy;

    /**
     * 集卡活动次日自动清空
     */
    private Boolean isAutoClear;


    private Integer openCustomization;

    private Integer rspPlugTimes;

    private List<Long> rspPlugIds;

    /**
     * 是否支持增值
     */
    private Boolean isEnc;
    /**
     * 是否是用户收藏活动
     */
    private Boolean isFavorite;

    /**
     * 优胜率（10000倍率）
     */
    private Long winningRate;

    /**
     * 表现优质广告位ID
     */
    private String slotIds;

    /**
     * 是否是高中奖活动：0、不是 1、是
     */
    private Integer isHighAwardRateActivity;

    /**
     * 是否是程序化活动
     */
    private Boolean programmatic;

    /**
     * 判断 tag 字段与传过来的集合是否有交集
     *
     * @param coll tag集合
     * @return boolean
     */
    public boolean containTags(Collection<String> coll) {
        if (StringUtils.isBlank(tag) || coll == null || coll.isEmpty()) {
            return false;
        }

        String tags = new StringBuilder(FieldNameSpace.COMMA).append(tag).append(FieldNameSpace.COMMA).toString();

        for (String str : coll) {
            if (tags.contains(FieldNameSpace.COMMA + str + FieldNameSpace.COMMA)) {
                return true;
            }
        }

        return false;
    }

}
