package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.plant.CheckDto;
import cn.com.duiba.tuia.activity.center.api.dto.plant.PlantDto;
import cn.com.duiba.tuia.activity.center.api.dto.plant.PlantUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.plant.config.PlantConfigDto;

/**
 * [种红包]Remote接口
 *
 * @author zhangbaiqiang
 * @date 2018/11/11
 */
@AdvancedFeignClient
public interface RemotePlantService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(PlantUserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param req 用户参数
     * @param landId 土地编号
     * @param seedType 种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(PlantUserReq req, Integer landId, Integer seedType) throws BizException;

    /**
     * 采摘红包
     *
     * @param req 用户参数
     * @param seedId 种子编号
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(PlantUserReq req, Long seedId) throws BizException;

    /**
     * 提现
     *
     * @param req 用户参数
     * @return 种红包用户信息
     * @throws BizException
     */
    PlantDto withdraw(PlantUserReq req) throws BizException;

    /**
     * 判断是否能够提现
     *
     * @param req 用户参数
     * @return 校验结果
     */
    CheckDto canWithdraw(PlantUserReq req);

    /**
     * 更新配置参数（慎用）
     *
     * @param appId 媒体id
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    Boolean updatePlantConfig(Long appId, PlantConfigDto configDto);

    /**
     * 初始化现金库存
     *
     * @param appId 媒体
     * @param stock 初始库存库存
     * @return 当前库存
     */
    Integer initCashStock(Long appId, Integer stock);

    /**
     * 清除用户首次签到奖励标记
     *
     * @param req 用户参数
     */
    void deleteFirstSignPrize(PlantUserReq req);

    /**
     * [测试用接口]清除缓存
     *
     * @param deviceId 设备id
     * @param appId 媒体id
     */
    Boolean resetForTest(String deviceId, Long appId);
}
