/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OrderBy
implements Serializable {
    private static final long serialVersionUID = 3200046027483541175L;
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private String columnName;
    private Direction direction;

    public static OrderBy by(String columnName) {
        return OrderBy.newOrderBy(DEFAULT_DIRECTION, columnName);
    }

    public static List<OrderBy> by(String ... columnNames) {
        Assert.notNull((Object)columnNames, (String)"columnNames must not be null!");
        Assert.isTrue((columnNames.length > 0 ? 1 : 0) != 0, (String)"At least one columnName must be given!");
        return Arrays.stream(columnNames).map(OrderBy::by).collect(Collectors.toList());
    }

    public static List<OrderBy> by(Direction direction, String ... columnNames) {
        Assert.notNull((Object)((Object)direction), (String)"Direction must not be null!");
        Assert.notNull((Object)columnNames, (String)"columnNames must not be null!");
        Assert.isTrue((columnNames.length > 0 ? 1 : 0) != 0, (String)"At least one columnName must be given!");
        return Arrays.stream(columnNames).map(it -> OrderBy.newOrderBy(direction, it)).collect(Collectors.toList());
    }

    public static OrderBy asc(String columnName) {
        return OrderBy.newOrderBy(Direction.ASC, columnName);
    }

    public static OrderBy desc(String columnName) {
        return OrderBy.newOrderBy(Direction.DESC, columnName);
    }

    static OrderBy newOrderBy(@Nullable Direction direction, String columnName) {
        if (Objects.isNull(columnName)) {
            throw new IllegalArgumentException("Property must not null!");
        }
        OrderBy orderBy = new OrderBy();
        orderBy.setColumnName(columnName);
        orderBy.setDirection(direction == null ? DEFAULT_DIRECTION : direction);
        return orderBy;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.columnName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy that = (OrderBy)obj;
        return this.direction.equals((Object)that.direction) && this.columnName.equals(that.columnName);
    }

    public String toString() {
        return String.format("%s: %s", new Object[]{this.columnName, this.direction});
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public static enum Direction {
        ASC,
        DESC;


        public boolean isAscending() {
            return this.equals((Object)ASC);
        }

        public boolean isDescending() {
            return this.equals((Object)DESC);
        }
    }
}

