package cn.com.duiba.tuia.activity.center.api.dto.inter;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import cn.com.duiba.tuia.activity.center.api.constant.HttpProperty;

/**
 * ClassName: InterfaceHttpRequestDto <br/>
 * Function: http请求参数. <br/>
 * Reason: . <br/>
 * date: 2017年4月14日 下午5:39:46 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class InterfaceHttpRequestDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    private Long              id;

    private String            interfaceCode;

    private String            ownName;

    private String            remoteName;

    private HttpProperty      propertyType;

    /**
     * Creates a new instance of InterfaceHttpRequestDto.
     */
    public InterfaceHttpRequestDto() {
        super();
    }

    /**
     * Creates a new instance of InterfaceHttpRequestDto.
     *
     * @param id
     * @param interfaceCode
     * @param ownName
     * @param remoteName
     * @param propertyType
     */
    public InterfaceHttpRequestDto(Long id, String interfaceCode, String ownName, String remoteName,
                                   HttpProperty propertyType) {
        super();
        this.id = id;
        this.interfaceCode = interfaceCode;
        this.ownName = ownName;
        this.remoteName = remoteName;
        this.propertyType = propertyType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getInterfaceCode() {
        return interfaceCode;
    }

    public void setInterfaceCode(String interfaceCode) {
        this.interfaceCode = interfaceCode;
    }

    public String getOwnName() {
        return ownName;
    }

    public void setOwnName(String ownName) {
        this.ownName = ownName;
    }

    public String getRemoteName() {
        return remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public HttpProperty getPropertyType() {
        return propertyType;
    }

    public void setPropertyType(HttpProperty propertyType) {
        this.propertyType = propertyType;
    }

}
