package cn.com.duiba.tuia.activity.center.api.dto.oceanengine;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author duiba
 */
@NoArgsConstructor
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class OceanRefreshTokenResponse {
    @JsonProperty("code")
    private Integer code;
    @JsonProperty("message")
    private String message;
    @JsonProperty("data")
    private DataDTO data;

    @NoArgsConstructor
    @Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class DataDTO {
        @JsonProperty("access_token")
        private String accessToken;
        @JsonProperty("expires_in")
        private Integer expiresIn;
        @JsonProperty("refresh_token")
        private String refreshToken;
        @JsonProperty("refresh_token_expires_in")
        private Integer refreshTokenExpiresIn;

        public OceanTokenRedisDTO convert() {
            OceanTokenRedisDTO oceanTokenRedisDTO = new OceanTokenRedisDTO();

            oceanTokenRedisDTO.setAccessToken(this.accessToken);
            oceanTokenRedisDTO.setRefreshToken(this.refreshToken);
            oceanTokenRedisDTO.setTokenExpiresTime(System.currentTimeMillis() / 1000 + this.expiresIn);
            oceanTokenRedisDTO.setRefreshTokenExpiresTime(System.currentTimeMillis() / 1000 + this.refreshTokenExpiresIn);
            return oceanTokenRedisDTO;
        }
    }


}
