package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandJumpLinkDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandJumpLinkQueryDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandJumpLinkUpdateDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteLandJumpLinkService {

    /**
     * 获取链接列表
     * @param dto
     * @return
     */
    PageDto<LandJumpLinkDto> getLandJumpLinkList(LandJumpLinkQueryDto dto);

    /**
     * 获取最早的可用链接
     * @param dto
     * @return
     */
    LandJumpLinkDto getLandJumpLink(LandJumpLinkQueryDto dto);

    List<LandJumpLinkDto> getLandJumpLinkListById(List<Long> ids);

    /**
     * 添加链接
     * @param dto
     * @return
     */
    Boolean addLandJumpLinkList(LandJumpLinkDto dto);

    /**
     * 批量添加落地页链接,会去重
     * @param list
     * @return
     */
    Boolean batchAddLandJumpLink(List<LandJumpLinkDto> list);

    /**
     * 修改链接
     * @param dto
     * @return
     */
    Boolean updateLandJumpLinkList(LandJumpLinkUpdateDto dto);
}
