package cn.com.duiba.tuia.activity.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
public class ProgrammaticActivityDto implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 是否删除
     */
    private Boolean isDelete;

    /**
     * 创建人id
     */
    private String adminId;

    /**
     * 最新编辑人id
     */
    private String latestAdminId;

    /**
     * 模版id
     */
    private Long modelId;

    /**
     * 模版名称
     */
    private String modelName;

    /**
     * 程序化活动名称
     */
    private String name;

    /**
     * 程序化活动描述
     */
    private String description;

    /**
     * 奖品不足报警提醒通知人
     */
    private String ddNoticeId;

    /**
     * 奖品不足报警提醒通知人电话
     */
    private String ddNoticePhone;

    /**
     * 活动策划人
     */
    private String planerId;

    /**
     * 程序化活动结构，比如说包含哪些组件，组件如何排列，等
     */
    private Object construction;

    /**
     * 额外数据，目前有活动数据、奖项、参与次数
     */
    private String extra;

    /**
     * 行为链路数据
     */
    private Object behavioralChain;

    /**
     * 组件提供方
     */
    private Object compilerPresets;

    /**
     * 状态字段，标识程序化模板现在编辑到什么程度了 1。初始化 2。已裂变活动不可编辑
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    private static final long serialVersionUID = 2653532862900550621L;
}
