package cn.com.duiba.tuia.activity.center.api.dto.oceanengine;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author duiba
 */
@NoArgsConstructor
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class OceanTokenResponse {

    @JsonProperty("code")
    private Integer code;
    @JsonProperty("message")
    private String message;
    @JsonProperty("data")
    private TokenDTO data;

    @NoArgsConstructor
    @Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class TokenDTO {
        @JsonProperty("access_token")
        private String accessToken;
        @JsonProperty("expires_in")
        private Long expiresIn;
        @JsonProperty("refresh_token")
        private String refreshToken;
        @JsonProperty("advertiser_id")
        private Long advertiserId;
        @JsonProperty("advertiser_ids")
        private List<Long> advertiserIds;
        @JsonProperty("refresh_token_expires_in")
        private Long refreshTokenExpiresIn;

        /**
         * 转换成redis中存储的格式
         * @return
         */
        public OceanTokenRedisDTO convert() {
            OceanTokenRedisDTO oceanTokenRedisDTO = new OceanTokenRedisDTO();
            oceanTokenRedisDTO.setAccessToken(this.accessToken);
            oceanTokenRedisDTO.setRefreshToken(this.refreshToken);
            oceanTokenRedisDTO.setTokenExpiresTime(System.currentTimeMillis() / 1000 + this.expiresIn);
            oceanTokenRedisDTO.setRefreshTokenExpiresTime(System.currentTimeMillis() / 1000 + this.refreshTokenExpiresIn);
//            oceanTokenRedisDTO.setAdvertiserId(this.advertiserId);
//            oceanTokenRedisDTO.setAdvertiserIds(this.advertiserIds);
            return oceanTokenRedisDTO;
        }
    }
}
