package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.HashMap;
import java.util.Map;

public enum TuiaSelfActivityTypeEnum {

    OTHER(0, "其他类型"),
    SCRATCH_CARD(1, "刮刮卡"),
    TURN_CIRCLE(2, "转盘(方形、圆形、九宫格)"),
    DOLLMAC(3, "娃娃机"),
    CUT_ROPE(4, "跳一跳"),
    SMASHG(6, "砸蛋"),
    TIGER(7, "摇奖机(老虎机)"),
    TURN_CARD(8, "翻牌子(卡牌、红包等)"),
    /**
     * 产品重新归类
     * use {@link #SET_DOLL} instead
     */
    @Deprecated
    FISHING_GOLD(10, "大海捞金"),
    NIU_DAN(11, "扭蛋机"),
    RED_PACKET(12, "(开、扯、拆等)红包"),
    /**
     * 产品重新归类
     * use {@link #BLIND_BOX_COLLECTION} instead
     */
    @Deprecated
    EXPRESS(13, "拆快递"),
    SET_DOLL(14, "套(圈、猫、兔子、娃娃、手机等)"),
    ROLLDICE(15, "摇一摇(骰子、签子、树、手机等)"),
    /**
     * 产品重新归类
     * use {@link #ROLLDICE} instead
     */
    @Deprecated
    DRAW_LOT(17, "摇签"),
    /**
     * 产品重新归类
     * use {@link #OTHER} instead
     */
    @Deprecated
    SHOT_ARROW(18, "射箭"),
    DIG_GOLD(19, "挖金矿"),
    /**
     * 产品重新归类
     * use {@link #SET_DOLL} instead
     */
    @Deprecated
    CATCH_RABBIT(20, "套兔子"),
    WALLET(21, "卡包"),
    /**
     * 产品重新归类
     * use {@link #BLIND_BOX_COLLECTION} instead
     */
    @Deprecated
    BLOW_BALLOON(23, "吹气球"),
    ADD_PACKET(31, "种红包(深度互动)"),
    DAY_DAY_GARDEN(32, "天天果园(深度互动)"),
    DIG_GOLDS(33, "挖矿(深度互动)"),
    SHENGDU_OTHER(34, "深度其他"),
    /**
     * 产品重新归类
     * use {@link #TURN_CARD} instead
     */
    @Deprecated
    TURN_BRAND(35, "红包翻牌子"),
    /**
     * 产品重新归类
     * use {@link #ROLLDICE} instead
     */
    @Deprecated
    MONEY_TREE(36, "摇钱树"),
    ANSWER_QUESTION(37, "答题闯关类"),
    /**
     * 产品重新归类
     * use {@link #SET_DOLL} instead
     */
    @Deprecated
    CANNONY_ATTACK(38, "炮击拿好礼"),
    /**
     * 产品重新归类
     * use {@link #TIGER} instead
     */
    @Deprecated
    LUCKY_DRAW(39, "幸运大抽奖"),
    /**
     * 产品重新归类
     * use {@link #SET_DOLL} instead
     */
    @Deprecated
    VIOLENT_ATTACK(40, "暴击拿好礼"),
    AGGRGATE_PAGES(41, "活动集合页"),
    /**
     * 产品重新归类
     * use {@link #SET_DOLL} instead
     */
    @Deprecated
    FISHING_KOI(42, "钓锦鲤"),
    /**
     * 产品重新归类
     * use {@link #TURN_CARD} instead
     */
    @Deprecated
    LUCKY_ROLL(43, "幸运翻牌"),
    /**
     * 产品重新归类
     * use {@link #NIU_DAN} instead
     */
    @Deprecated
    EGG_TWISTER(44, "扭蛋机"),
    /**
     * 产品重新归类
     * use {@link #SET_DOLL} instead
     */
    @Deprecated
    DOLLS_GET(45, "套娃娃"),
    /**
     * 产品重新归类
     * use {@link #BLIND_BOX_COLLECTION} instead
     */
    @Deprecated
    DAY_DAY_SENT(46, "福利天天送"),

    ONE_FLY_DAY(47, "一飞冲天"),

    RICH_MAN(48, "大富翁"),
    /**
     * 产品重新归类
     * use {@link #OTHER} instead
     */
    @Deprecated
    LUCKY_EIGHT(49, "幸运八连抽"),
    /**
     * 产品重新归类
     * use {@link #TIGER} instead
     */
    @Deprecated
    COLLECT_WORLD(50, "集字摇奖机"),
    ANIPOP(51, "消消乐"),
    BLIND_BOX_COLLECTION(52,"盲盒(开礼盒、拆快递等)")
    ;

    private static Map<Integer, String> typeDescMap = new HashMap<>(64);
    static {
        final TuiaSelfActivityTypeEnum[] values = TuiaSelfActivityTypeEnum.values();
        for (TuiaSelfActivityTypeEnum value : values) {
            typeDescMap.put(value.getType(), value.getDesc());
        }
    }

    private Integer type;
    private String desc;

    TuiaSelfActivityTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        return typeDescMap.get(type);
    }
}
