package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.ContactPlateDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by xuefeng on 2017/11/23.
 */
@AdvancedFeignClient
public interface RemoteContactPlateService {

    /**
     * 获取分野列表信息
     *
     * @param offset
     * @param max
     * @param id
     * @param title       标题
     * @param relatedHost 域名
     * @return
     */
    PageDto<ContactPlateDto> getPageList(int offset, int max, Long id, String title, String relatedHost);

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Boolean addContactPlate(ContactPlateDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Boolean updateContactPlate(ContactPlateDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Boolean deleteContactPlate(Long id);


    Integer deleteLogicContactPlate(Long id,Long slotId);



    ContactPlateDto  getContactPlateByHost(String host);


    ContactPlateDto  getContactPlateBySlot(String host);
    /**
     * 关联域名
     *
     * @param id
     * @param relatedHost
     * @return
     */
    DubboResult<List<ContactPlateDto>> relateHost(Long id, String relatedHost);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    ContactPlateDto getById(Long id);

    /**
     * 根据域名查找关联客服信息模版
     *
     * @param host
     * @return
     */
    ContactPlateDto getDtoByHost(String host);
}
