package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.WacaiLogCustomDTO;

import java.util.List;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-01-06
 */
@AdvancedFeignClient
public interface RemoteWacaiLogCustomService {
    /**
     * 插入
     * @param aTuiaId 推啊订单id
     * @param aCid 推啊用户id
     * @param aTimeStamp 用户转化时间戳
     * @param advertKey 广告主id加密字符串
     * @return int
     */
    Integer insert(String aTuiaId, Long aCid, String aTimeStamp, String advertKey);

    /**
     * 根据推啊订单id删除记录
     * @param aTuiaId 推啊订单id
     * @return int
     */
    Integer deleteByTuiaId(String aTuiaId);

    /**
     * 查询一段时间内的记录，左闭右开
     * @param startTime 起始时间
     * @param endTime 结束时间
     * @return 集合
     */
    List<WacaiLogCustomDTO> selectByTimeRange(String startTime, String endTime);
}
