/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final Map<String, DateTimeFormatter> FORMATTER_CACHE = new HashMap<String, DateTimeFormatter>();
    private static final String YYYY_FORMAT = "yyyy";
    private static final String MM_DD_FORMAT = "MM-dd";
    private static final String MINUTE_FORMAT = "yyyyMMdd-HHmm";
    private static final String MONTH_DAY_YEAR_FORMAT = "MM/dd/yyyy";
    private static final String SECOND_ONLY_FORMAT = "HH:mm:ss";
    private static final String SECOND_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String MINUTE_NORMAL_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String MINUTE_ONLY_FORMAT = "HH:mm";
    private static final String DAY_FORMAT = "yyyy-MM-dd";
    private static final String DAY_NUMBER_FORMAT = "yyyyMMdd";
    private static final String YEAR_DAY_NUMBER_FORMAT = "yyMMdd";
    private static final String MILLI_SECOND_FORMAT = "yyyyMMddHHmmssSSS";
    private static final String SECOND_FORMAT_NO_SYMBOL = "yyyyMMddHHmmss";
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = TimeFormat.access$000(TimeFormat.LONG_DATE_PATTERN_LINE);

    private DateUtils() {
    }

    public static String getYearStr(Date date) {
        return DateUtils.formatDate(date, YYYY_FORMAT);
    }

    public static String getYearStr(long date) {
        return DateUtils.formatDate(date, YYYY_FORMAT);
    }

    public static String getMinuteDbStr(Date date) {
        return DateUtils.formatDateTime(date, MINUTE_FORMAT);
    }

    public static Date getMinuteDbDate(String str) {
        return DateUtils.getDateTime(str, MINUTE_FORMAT);
    }

    public static Date getMonDayYearDate(String str) {
        return DateUtils.getDate(str, MONTH_DAY_YEAR_FORMAT);
    }

    public static String getSecondOnlyStr(Date date) {
        return DateUtils.formatDateTime(date, SECOND_ONLY_FORMAT);
    }

    public static String getSecondOnlyStr(long timestamp) {
        return DateUtils.formatDateTime(timestamp, SECOND_ONLY_FORMAT);
    }

    public static String getOnlyDayStr(long timestamp) {
        return DateUtils.formatDateTime(timestamp, MM_DD_FORMAT);
    }

    public static String getSecondStr(long timestamp) {
        return DateUtils.formatDateTime(timestamp, SECOND_FORMAT);
    }

    public static String getSecondStr(Date date) {
        return DateUtils.formatDateTime(date, SECOND_FORMAT);
    }

    public static String getMinuteStr(Date date) {
        return DateUtils.formatDateTime(date, MINUTE_NORMAL_FORMAT);
    }

    public static String getMinuteStr(long timestamp) {
        return DateUtils.formatDateTime(timestamp, MINUTE_NORMAL_FORMAT);
    }

    public static String getMinuteOnlyStr(Date date) {
        return DateUtils.formatDateTime(date, MINUTE_ONLY_FORMAT);
    }

    public static String getDayStr(Date date) {
        return DateUtils.formatDate(date, DAY_FORMAT);
    }

    public static String getDayStr(long timestamp) {
        return DateUtils.formatDate(timestamp, DAY_FORMAT);
    }

    public static int getDayNumber(Date date) {
        if (date == null) {
            return 0;
        }
        return Integer.valueOf(DateUtils.formatDate(date, DAY_NUMBER_FORMAT));
    }

    public static int getYYDayNumber(Date date) {
        if (date == null) {
            return 0;
        }
        return Integer.valueOf(DateUtils.formatDate(date, YEAR_DAY_NUMBER_FORMAT));
    }

    public static Date getDayDate(Date date) {
        return DateUtils.getDayDate(DateUtils.getDayStr(date));
    }

    public static Date getSecondDate(String dateStr) {
        return DateUtils.getDateTime(dateStr, SECOND_FORMAT);
    }

    public static Date getDayDate(String dateStr) {
        return DateUtils.getDate(dateStr, DAY_FORMAT);
    }

    public static Date getMinuteOnlyDate(String dateStr) {
        String newDateStr = LocalDate.ofEpochDay(0L).toString() + " " + dateStr;
        return DateUtils.getDateTime(newDateStr, MINUTE_NORMAL_FORMAT);
    }

    public static Date getMinuteDate(String dateStr) {
        return DateUtils.getDateTime(dateStr, MINUTE_NORMAL_FORMAT);
    }

    public static Date getMinuteDate(long time) {
        return DateUtils.getMinuteDate(DateUtils.getMinuteStr(time));
    }

    public static long getMiniteDate(Date date, String str) {
        if (str == null) {
            return 0L;
        }
        Date date1 = DateUtils.getMinuteDate(DateUtils.getDayStr(date) + " " + str);
        if (date1 == null) {
            return 0L;
        }
        return date1.getTime();
    }

    private static Date getDate(String dateStr, String pattern) {
        LocalDate localDate = DateUtils.getLocalDate(dateStr, pattern);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private static LocalDate getLocalDate(String dateStr, String pattern) {
        DateTimeFormatter formatter = DateUtils.getOrCreateFormatter(pattern);
        return LocalDate.parse(dateStr, formatter);
    }

    private static Date getDateTime(String dateStr, String pattern) {
        LocalDateTime localDateTime = DateUtils.getLocalDateTime(dateStr, pattern);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private static LocalDateTime getLocalDateTime(String dateStr, String pattern) {
        DateTimeFormatter formatter = DateUtils.getOrCreateFormatter(pattern);
        return LocalDateTime.parse(dateStr, formatter);
    }

    private static String formatDate(Date date, String pattern) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.format(DateUtils.getOrCreateFormatter(pattern));
    }

    private static String formatDateTime(Date date, String pattern) {
        LocalDateTime localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDate.format(DateUtils.getOrCreateFormatter(pattern));
    }

    private static String formatDate(long timestamp, String pattern) {
        LocalDate localDate = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.format(DateUtils.getOrCreateFormatter(pattern));
    }

    private static String formatDateTime(long timestamp, String pattern) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(DateUtils.getOrCreateFormatter(pattern));
    }

    private static DateTimeFormatter getOrCreateFormatter(String pattern) {
        DateTimeFormatter formatter;
        if (FORMATTER_CACHE.containsKey(pattern)) {
            formatter = FORMATTER_CACHE.get(pattern);
        } else {
            formatter = DateTimeFormatter.ofPattern(pattern);
            FORMATTER_CACHE.put(pattern, formatter);
        }
        return formatter;
    }

    public static Date monthsAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 2, offset);
    }

    public static Date daysAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 5, offset);
    }

    public static Date hoursAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 11, offset);
    }

    public static Date minutesAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 12, offset);
    }

    public static Date secondsAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 13, offset);
    }

    public static boolean isTimeString(String toCheck) {
        if (!StringUtils.isNotBlank((String)toCheck)) {
            return false;
        }
        return toCheck.trim().matches("([0-1][0-9]|2[0-3]):[0-5][0-9]|24:00");
    }

    public static int compareHHmmInString(String ts1, String ts2) {
        return ts1.compareTo(ts2);
    }

    public static int betweenHHmmInString(String ts, String start, String end) {
        if (DateUtils.compareHHmmInString(start, end) >= 0) {
            return -1;
        }
        if (DateUtils.compareHHmmInString(ts, start) < 0) {
            return 0;
        }
        if (DateUtils.compareHHmmInString(end, ts) <= 0) {
            return 0;
        }
        return 1;
    }

    public static boolean equalsInTimeString(String ts1, String ts2) {
        if (ts1.equals(ts2)) {
            return true;
        }
        return !(!"00:00".equals(ts1) && !"24:00".equals(ts1) || !"00:00".equals(ts2) && !"24:00".equals(ts2));
    }

    public static String getMillisecond() {
        return DateUtils.formatDateTime(new Date(), MILLI_SECOND_FORMAT);
    }

    public static String getSecondNoSymbol() {
        return DateUtils.formatDateTime(new Date(), SECOND_FORMAT_NO_SYMBOL);
    }

    public static String getSecondNoSymbol(Date date) {
        return DateUtils.formatDateTime(date, SECOND_FORMAT_NO_SYMBOL);
    }

    public static int compareHHmm(Calendar cal, Calendar c) {
        if (cal.get(11) > c.get(11)) {
            return 1;
        }
        if (cal.get(11) == c.get(11)) {
            if (cal.get(12) > c.get(12)) {
                return 1;
            }
            if (cal.get(12) == c.get(12)) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static int betweenHHmm(Calendar cal, Calendar start, Calendar end) {
        if (DateUtils.compareHHmm(start, end) != -1) {
            return -1;
        }
        if (DateUtils.compareHHmm(cal, start) == -1) {
            return 0;
        }
        if (DateUtils.compareHHmm(end, cal) == -1) {
            return 0;
        }
        return 1;
    }

    public static boolean compareDay(Calendar cal, Calendar c) {
        return cal.get(1) == c.get(1) && cal.get(2) == c.get(2) && cal.get(5) == c.get(5);
    }

    public static Calendar string2calendar(String timeString) throws Exception {
        if (!DateUtils.isTimeString(timeString)) {
            throw new Exception("Wrong argument : timeString format error " + timeString);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, DateUtils.getHour(timeString));
        cal.set(12, DateUtils.getMinute(timeString));
        return cal;
    }

    public static String calendar2TimeString(Calendar cal) {
        return (cal.get(11) > 9 ? Integer.valueOf(cal.get(11)) : "0" + cal.get(11)) + ":" + (cal.get(12) > 9 ? Integer.valueOf(cal.get(12)) : "0" + cal.get(12));
    }

    public static int getHour(String timeString) {
        return Integer.parseInt(timeString.substring(0, 2));
    }

    public static int getMinute(String timeString) {
        return Integer.parseInt(timeString.substring(3, 5));
    }

    public static String getDateOnlyFromDate(String dateString) {
        return dateString.substring(5, 10);
    }

    public static String calendar2DateString(Calendar cal) {
        return (cal.get(2) + 1 > 9 ? Integer.valueOf(cal.get(2) + 1) : "0" + (cal.get(2) + 1)) + "-" + (cal.get(5) > 9 ? Integer.valueOf(cal.get(5)) : "0" + cal.get(5));
    }

    public static Integer monthSub(Date beginDate, Date endDate) {
        Integer monthNum = 0;
        Integer yearNumber = 0;
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(beginDate);
        endCalendar.setTime(endDate);
        yearNumber = endCalendar.get(1) - startCalendar.get(1);
        monthNum = endCalendar.get(2) - startCalendar.get(2);
        return yearNumber * 12 + monthNum;
    }

    public static Date getMonthDayByIndex(Date beginDate, int index) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        cal.set(5, index);
        return cal.getTime();
    }

    public static Map<String, Date> retTodayAndTomorrow() {
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        Date start = DateUtils.getDayDate(new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        cal.add(5, 1);
        Date end = cal.getTime();
        dateMap.put("startDay", start);
        dateMap.put("endDay", end);
        return dateMap;
    }

    public static int getToTomorrowSeconds() {
        Calendar curDate = Calendar.getInstance();
        GregorianCalendar tommorowDate = new GregorianCalendar(curDate.get(1), curDate.get(2), curDate.get(5) + 1, 0, 0, 0);
        return Math.max((int)((tommorowDate.getTimeInMillis() - curDate.getTimeInMillis()) / 1000L), 1);
    }

    public static long getTodayZeroTimeInMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long getMonthFirstDayTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long getNextMonthFirstDayTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long getDifferDay(Date date) {
        Date nowDate = new Date();
        if (nowDate.after(date)) {
            return 0L;
        }
        return Math.abs(date.getTime() - nowDate.getTime()) / 86400000L + (long)(Math.abs(date.getTime() - nowDate.getTime()) % 86400000L == 0L ? 0 : 1);
    }

    private static Date addOrSub(Date date, int type, int offset) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.get(type);
        cal.set(type, cal.get(type) + offset);
        return cal.getTime();
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    private static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null) {
            return null;
        }
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            LOG.error("format yyyy-MM-dd HH:mm:ss error:", (Throwable)e);
            return null;
        }
    }

    public static Date getMondayDate(Date day) {
        Calendar calWeek = Calendar.getInstance();
        calWeek.setTime(day);
        if (1 == calWeek.get(7)) {
            calWeek.add(5, -6);
        } else if (2 == calWeek.get(7)) {
            calWeek.add(5, -7);
        } else if (3 == calWeek.get(7)) {
            calWeek.add(5, -1);
        } else if (4 == calWeek.get(7)) {
            calWeek.add(5, -2);
        } else if (5 == calWeek.get(7)) {
            calWeek.add(5, -3);
        } else if (6 == calWeek.get(7)) {
            calWeek.add(5, -4);
        } else if (7 == calWeek.get(7)) {
            calWeek.add(5, -5);
        }
        return DateUtils.getDayDate(calWeek.getTime());
    }

    public static Date getFirstDayDate(Date day) {
        Calendar calMonth = Calendar.getInstance();
        calMonth.setTime(day);
        if (1 == calMonth.get(5)) {
            calMonth.setTime(DateUtils.daysAddOrSub(day, -1));
        }
        calMonth.set(5, 1);
        return DateUtils.getDayDate(calMonth.getTime());
    }

    public static Date getDayStartTime(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEndTime(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayStartTime(String strDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getDayDate(strDate));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEndTime(String strDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getDayDate(strDate));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static int daysBetween(Date smdate, Date bdate) {
        smdate = DateUtils.getDayDate(smdate);
        bdate = DateUtils.getDayDate(bdate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static Date changeByDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return cal.getTime();
    }

    public static String getYesterday() {
        SimpleDateFormat dft = new SimpleDateFormat(DAY_FORMAT);
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        date.set(5, date.get(5) - 1);
        Date endDate = null;
        try {
            endDate = dft.parse(dft.format(date.getTime()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return dft.format(endDate);
    }

    public static LocalDateTime parseTime(String timeStr) {
        return LocalDateTime.parse(timeStr, DEFAULT_DATETIME_FORMATTER);
    }

    public static LocalDateTime parseTime(String timeStr, TimeFormat format) {
        return LocalDateTime.parse(timeStr, format.formatter);
    }

    public static LocalDate parseLocalDate(String timeStr, TimeFormat format) {
        return LocalDate.parse(timeStr, format.formatter);
    }

    public static String parseTime(LocalDateTime time) {
        return DEFAULT_DATETIME_FORMATTER.format(time);
    }

    public static String parseTime(LocalDateTime time, TimeFormat format) {
        return format.formatter.format(time);
    }

    public static String parseLocalDate(LocalDate time, TimeFormat format) {
        return format.formatter.format(time);
    }

    public static String getCurrentDatetime() {
        return DEFAULT_DATETIME_FORMATTER.format(LocalDateTime.now());
    }

    public static String getCurrentDatetime(TimeFormat format) {
        return format.formatter.format(LocalDateTime.now());
    }

    public static Period LocalDateDiff(LocalDate lt, LocalDate gt) {
        Period p = Period.between(lt, gt);
        return p;
    }

    public static String localDateDiffFormat(LocalDate lt, LocalDate gt) {
        Period p = Period.between(lt, gt);
        String str = String.format(" %d\u5e74 %d\u6708 %d\u65e5", p.getYears(), p.getMonths(), p.getDays());
        return str;
    }

    public static Duration localTimeDiff(LocalTime lt, LocalTime gt) {
        Duration d = Duration.between(lt, gt);
        return d;
    }

    public static long millisDiff(LocalTime lt, LocalTime gt) {
        Duration d = Duration.between(lt, gt);
        return d.toMillis();
    }

    public static long secondDiff(LocalTime lt, LocalTime gt) {
        Duration d = Duration.between(lt, gt);
        return d.getSeconds();
    }

    public static long daysDiff(LocalDate lt, LocalDate gt) {
        long daysDiff = ChronoUnit.DAYS.between(lt, gt);
        return daysDiff;
    }

    public static long hoursDiff(LocalDate lt, LocalDate gt) {
        long hoursDiff = ChronoUnit.HOURS.between(lt, gt);
        return hoursDiff;
    }

    public static LocalDate getFirstDayOfLastMonth(LocalDate date) {
        return date.with(temporal -> temporal.with(ChronoField.DAY_OF_MONTH, 1L).plus(-1L, ChronoUnit.MONTHS));
    }

    public static LocalDate getLastDayOfLastMonth(LocalDate date) {
        return date.with(temporal -> temporal.with(ChronoField.DAY_OF_MONTH, temporal.range(ChronoField.DAY_OF_MONTH).getMaximum()).plus(-1L, ChronoUnit.MONTHS));
    }

    public static LocalDate getFirstDayOfMonth(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getLastDayOfMonth(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate getFirstDayOfNextMonth(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfNextMonth());
    }

    public static LocalDate getLastDayOfNextMonth(LocalDate date) {
        return date.with(temporal -> temporal.with(ChronoField.DAY_OF_MONTH, temporal.range(ChronoField.DAY_OF_MONTH).getMaximum()).plus(1L, ChronoUnit.MONTHS));
    }

    public static LocalDate getFirstDayOfLastYear(LocalDate date) {
        return date.with(temporal -> temporal.with(ChronoField.DAY_OF_YEAR, 1L).plus(-1L, ChronoUnit.YEARS));
    }

    public static LocalDate getLastDayOfLastYear(LocalDate date) {
        return date.with(temporal -> temporal.with(ChronoField.DAY_OF_YEAR, temporal.range(ChronoField.DAY_OF_YEAR).getMaximum()).plus(-1L, ChronoUnit.YEARS));
    }

    public static LocalDate getFirstDayOfYear(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDate getLastDayOfYear(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfYear());
    }

    public static LocalDate getFirstDayOfNextYear(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfNextYear());
    }

    public static LocalDate getLastDayOfNextYear(LocalDate date) {
        return date.with(temporal -> temporal.with(ChronoField.DAY_OF_YEAR, temporal.range(ChronoField.DAY_OF_YEAR).getMaximum()).plus(1L, ChronoUnit.YEARS));
    }

    public static LocalDate getFirstInMonth(LocalDate date, DayOfWeek dayOfWeek) {
        return date.with(TemporalAdjusters.firstInMonth(dayOfWeek));
    }

    public static LocalDate getNext(LocalDate date, DayOfWeek dayOfWeek) {
        return date.with(TemporalAdjusters.next(dayOfWeek));
    }

    public static LocalDate getPrevious(LocalDate date, DayOfWeek dayOfWeek) {
        return date.with(TemporalAdjusters.previous(dayOfWeek));
    }

    public static LocalDate getNextOrSame(LocalDate date, DayOfWeek dayOfWeek) {
        return date.with(TemporalAdjusters.nextOrSame(dayOfWeek));
    }

    public static LocalDate getPreviousOrSame(LocalDate date, DayOfWeek dayOfWeek) {
        return date.with(TemporalAdjusters.previousOrSame(dayOfWeek));
    }

    public static Boolean checkIsWeek(LocalDate date) {
        if (date != DateUtils.getNextOrSame(LocalDate.now(), DayOfWeek.MONDAY) && date != DateUtils.getNextOrSame(LocalDate.now(), DayOfWeek.SATURDAY)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(SECOND_FORMAT);
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static Long getTimeDifference(Long time) {
        return (System.currentTimeMillis() - time) / 1000L;
    }

    public static enum TimeFormat {
        SHORT_DATE_PATTERN_CHINESE("yyyy\u5e74MM\u6708dd\u65e5"),
        SHORT_DATE_PATTERN_LINE("yyyy-MM-dd"),
        SHORT_DATE_PATTERN_SLASH("yyyy/MM/dd"),
        SHORT_DATE_PATTERN_DOUBLE_SLASH("yyyy\\MM\\dd"),
        SHORT_DATE_PATTERN_NONE("yyyyMMdd"),
        SHORT_DATE_PATTERN_MINUTES("yyyyMMddHHmm"),
        SHORT_DATE_PATTERN_HOURS("yyyyMMddHH"),
        LONG_DATE_PATTERN_LINE("yyyy-MM-dd HH:mm:ss"),
        LONG_DATE_PATTERN_SLASH("yyyy/MM/dd HH:mm:ss"),
        LONG_DATE_PATTERN_DOUBLE_SLASH("yyyy\\MM\\dd HH:mm:ss"),
        LONG_DATE_PATTERN_NONE("yyyyMMdd HH:mm:ss"),
        LONG_DATE_PATTERN_WITH_MILSEC_LINE("yyyy-MM-dd HH:mm:ss.SSS"),
        LONG_DATE_PATTERN_WITH_MILSEC_SLASH("yyyy/MM/dd HH:mm:ss.SSS"),
        LONG_DATE_PATTERN_WITH_MILSEC_DOUBLE_SLASH("yyyy\\MM\\dd HH:mm:ss.SSS"),
        LONG_DATE_PATTERN_WITH_MILSEC_NONE("yyyyMMdd HH:mm:ss.SSS");

        private transient DateTimeFormatter formatter;

        private TimeFormat(String pattern) {
            this.formatter = DateTimeFormatter.ofPattern(pattern);
        }
    }
}

