package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.zt.AntScorePoolDTO;


/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteAntScorePoolService {

    AntScorePoolDTO insert(AntScorePoolDTO dto);

    AntScorePoolDTO getAntScoreWithTheSameSubType(String subtype, Long strategyId);

    /**
     * 根据tuiaId来更新所有的池中数据的状态
     *
     * @param tuiaId
     * @param reportStatus
     * @return
     */
    int updateReportStatus(String tuiaId, Integer reportStatus);

    /**
     * 找出小于当前tuiaTupe且antscore大于某个阈值的蚂蚁支付分最高的那个
     * 进行上报
     */
    AntScorePoolDTO getMaxAntScoreOrderByTuiaType(Integer antScore, Integer tuiaType, Long strategyId, String dateTime);
}
