package cn.com.duiba.tuia.activity.center.api.bean.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author Wangpf
 * @version
 */
public enum JmLayerNewTagsNumEnum {

    MAIN_TITLE("10", "主标题"),

    SUB_HEAD("11", "副标题"),

    BENEFIT("12", "利益点"),

    TRADE_CHART("13", "商品图标签")

    ;

    private final String desc;

    private final String code;

    JmLayerNewTagsNumEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, JmLayerNewTagsNumEnum> enumMap = Maps.newHashMap();
    static {
        for (JmLayerNewTagsNumEnum it : JmLayerNewTagsNumEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static JmLayerNewTagsNumEnum getByName(String code) {
        return enumMap.get(code);
    }
}
