package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityOptionDto;
import cn.com.duiba.tuia.activity.center.api.dto.ActivitySkinDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityType;
import cn.com.duiba.tuia.activity.center.api.dto.SkinTemplateDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.TuiaActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteActivityService <br/>
 * Function: 活动服务和活动奖项，皮肤相关服务. <br/>
 * date: 2017年1月12日 下午9:15:42 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public interface RemoteActivityService {

    /**
     * getActivity:(查询活动). <br/>
     *
     * @param id the id
     * @return the activity
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<TuiaActivityDto> getActivity(Long id);
    
    /**
     * getActivity:(批量查询活动). <br/>
     *
     * @param ids the ids
     * @return the activity list
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<List<TuiaActivityDto>> getActivityList(List<Long> ids);

    /**
     * deleteActivity:(删除活动). <br/>
     * 软删
     *
     * @param id the id
     * @return the dubbo result< long>
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Long> deleteActivity(Long id);

    /**
     * saveActivity:(根据id更新活动). <br/>
     * 参数传null会在数据库里存null
     *
     * @param dto 活动dto
     * @return long
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Long> saveActivity(TuiaActivityDto dto);

    /**
     * selectPageActivity:(分页查询活动). <br/>
     *
     * @param offset the offset
     * @param max the max
     * @param title 活动标题 null 不传null的情况下,%title%查询
     * @return page
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<PageDto<TuiaActivityDto>> selectPageActivity(Integer offset, Integer max, String title, String type);
    
    /**
     * selectActivityOptionByActivityId:(根据活动id查询活动的奖项). <br/>
     *
     * @param activityId 活动id not null
     * @param includeStock 是否包含库存值(库存值需要调库存中心查询，不需要的话就不要查询)
     * @return the dubbo result< list< activity option dto>>
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<List<ActivityOptionDto>> selectActivityOptionByActivityId(Long activityId,Boolean includeStock);

    /**
     * selectActivityOption:(根据id查询奖项). <br/>
     *
     * @param optionId 奖项id
     * @return the dubbo result< activity option dto>
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<ActivityOptionDto> selectActivityOption(Long optionId);

    /**
     * saveActivityOption:(保存奖项). <br/>
     * 有id update <br/>
     * 无id insert <br/>
     *
     * @param options 批量保存奖项
     * @return 保存的数量
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Integer> saveActivityOption(List<ActivityOptionDto> options);

    /**
     * deleteActivityOption:(删除奖项). <br/>
     *
     * @param optionId 奖项id
     * @return optionId
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Integer> deleteActivityOption(Long optionId);

    /**
     * deleteActivityOption:(批量删除奖项). <br/>
     *
     * @param optionIds 奖项ids
     * @return 删除数量
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Integer> deleteActivityOption(List<Long> optionIds);

    /**
     * selectSkinTemplateById:(根据id查询皮肤模板数据). <br/>
     *
     * @param id the id
     * @return the dubbo result< skin template data dto>
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<SkinTemplateDataDto> selectSkinTemplateById(Long id);

    /**
     * selectSkinTemplateByTemplateType:(查询某活动类型所属的皮肤模板). <br/>
     *
     * @param templateType 皮肤模板类型或者活动类型
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<List<SkinTemplateDataDto>> selectSkinTemplateByTemplateType(Integer templateType);

    /**
     * selectSkinTemplateBySkinType:(根据模板标识 查询). <br/>
     *
     * @param skinType 模板标识(唯一的存在)
     * @return the dubbo result< skin template data dto>
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<SkinTemplateDataDto> selectSkinTemplateBySkinType(String skinType);

    /**
     * saveSkinTemplate:(保存皮肤模板). <br/>
     * 有id update <br/>
     * 无id insert <br/>
     *
     * @param dto the dto
     * @return id
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Long> saveSkinTemplate(SkinTemplateDataDto dto);

    /**
     * selectSkinTemplateByPage:(分页查询模板). <br/>
     *
     * @param offset the offset
     * @param max the max
     * @return page
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<PageDto<SkinTemplateDataDto>> selectSkinTemplateByPage(Integer offset, Integer max);

    /**
     * selectActivitySkinByActivityId:(查询活动皮肤). <br/>
     *
     * @param activityId the activity id
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<ActivitySkinDataDto> selectActivitySkinByActivityId(Long activityId);

    /**
     * insertActivitySkin:(添加活动皮肤关系表). <br/>
     *
     * @param dto the dto
     * @return id
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Long> insertActivitySkin(ActivitySkinDataDto dto);

    /**
     * updateActivitySkinDataByActivityId:(更新活动皮肤). <br/>
     *
     * @param activityId the activity id
     * @param dataJson the data json
     * @return activityId
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<Long> updateActivitySkinDataByActivityId(Long activityId, String dataJson);

    /**
     * selectAllActivityType:(查询所有的活动类型). <br/>
     *
     * @return Integer:String 活动类型：活动类型名称
     * @author wubo
     * @since JDK 1.7
     */
    public DubboResult<List<ActivityType>> selectAllActivityType();

}
